/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.PlatformElemViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface PlatformElem
extends VertexViewer {
    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_PLATFORMELEM)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_PLATFORMELEM)) continue;
            return true;
        }
        return false;
    }

    public static Optional<PlatformElem> safeCast(Vertex vertex) {
        return PlatformElem.conforms(vertex) != false ? Optional.of(new PlatformElemViewer(vertex)) : Optional.empty();
    }

    public static Optional<PlatformElem> safeCast(VertexViewer viewer) {
        return PlatformElem.conforms(viewer.getViewedVertex()) != false ? Optional.of(new PlatformElemViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static PlatformElem enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.PLATFORM_PLATFORMELEM);
        vertex.ports.addAll(PlatformElem.getRequiredPorts());
        for (String key : PlatformElem.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, PlatformElem.getRequiredProperties().get(key));
        }
        return new PlatformElemViewer(vertex);
    }

    public static PlatformElem enforce(VertexViewer viewer) {
        return PlatformElem.enforce(viewer.getViewedVertex());
    }
}

