/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.platform.runtime;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.runtime.AbstractScheduler;
import forsyde.io.java.typed.viewers.platform.runtime.FixedPrioritySchedulerViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface FixedPriorityScheduler
extends AbstractScheduler,
VertexViewer {
    default public Boolean getPreemptive() {
        return this.getViewedVertex().getProperties().containsKey("preemptive") ? (Boolean)this.getViewedVertex().getProperties().get("preemptive").unwrap() : null;
    }

    default public void setPreemptive(Boolean preemptive) {
        this.getViewedVertex().getProperties().put("preemptive", VertexProperty.create(preemptive));
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_RUNTIME_FIXEDPRIORITYSCHEDULER)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_RUNTIME_FIXEDPRIORITYSCHEDULER)) continue;
            return true;
        }
        return false;
    }

    public static Optional<FixedPriorityScheduler> safeCast(Vertex vertex) {
        return FixedPriorityScheduler.conforms(vertex) != false ? Optional.of(new FixedPrioritySchedulerViewer(vertex)) : Optional.empty();
    }

    public static Optional<FixedPriorityScheduler> safeCast(VertexViewer viewer) {
        return FixedPriorityScheduler.conforms(viewer.getViewedVertex()) != false ? Optional.of(new FixedPrioritySchedulerViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static FixedPriorityScheduler enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.PLATFORM_RUNTIME_FIXEDPRIORITYSCHEDULER);
        vertex.ports.addAll(FixedPriorityScheduler.getRequiredPorts());
        for (String key : FixedPriorityScheduler.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, FixedPriorityScheduler.getRequiredProperties().get(key));
        }
        return new FixedPrioritySchedulerViewer(vertex);
    }

    public static FixedPriorityScheduler enforce(VertexViewer viewer) {
        return FixedPriorityScheduler.enforce(viewer.getViewedVertex());
    }
}

