/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.platform.runtime;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.runtime.AbstractScheduler;
import forsyde.io.java.typed.viewers.platform.runtime.RoundRobinSchedulerViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface RoundRobinScheduler
extends AbstractScheduler,
VertexViewer {
    default public Long getMaximumTimeSliceInCycles() {
        return this.getViewedVertex().getProperties().containsKey("maximumTimeSliceInCycles") ? (Long)this.getViewedVertex().getProperties().get("maximumTimeSliceInCycles").unwrap() : null;
    }

    default public void setMaximumTimeSliceInCycles(Long maximumTimeSliceInCycles) {
        this.getViewedVertex().getProperties().put("maximumTimeSliceInCycles", VertexProperty.create(maximumTimeSliceInCycles));
    }

    default public Long getMinimumTimeSliceInCycles() {
        return this.getViewedVertex().getProperties().containsKey("minimumTimeSliceInCycles") ? (Long)this.getViewedVertex().getProperties().get("minimumTimeSliceInCycles").unwrap() : null;
    }

    default public void setMinimumTimeSliceInCycles(Long minimumTimeSliceInCycles) {
        this.getViewedVertex().getProperties().put("minimumTimeSliceInCycles", VertexProperty.create(minimumTimeSliceInCycles));
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_RUNTIME_ROUNDROBINSCHEDULER)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_RUNTIME_ROUNDROBINSCHEDULER)) continue;
            return true;
        }
        return false;
    }

    public static Optional<RoundRobinScheduler> safeCast(Vertex vertex) {
        return RoundRobinScheduler.conforms(vertex) != false ? Optional.of(new RoundRobinSchedulerViewer(vertex)) : Optional.empty();
    }

    public static Optional<RoundRobinScheduler> safeCast(VertexViewer viewer) {
        return RoundRobinScheduler.conforms(viewer.getViewedVertex()) != false ? Optional.of(new RoundRobinSchedulerViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static RoundRobinScheduler enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.PLATFORM_RUNTIME_ROUNDROBINSCHEDULER);
        vertex.ports.addAll(RoundRobinScheduler.getRequiredPorts());
        for (String key : RoundRobinScheduler.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, RoundRobinScheduler.getRequiredProperties().get(key));
        }
        return new RoundRobinSchedulerViewer(vertex);
    }

    public static RoundRobinScheduler enforce(VertexViewer viewer) {
        return RoundRobinScheduler.enforce(viewer.getViewedVertex());
    }
}

