/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.platform.runtime;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.runtime.AbstractScheduler;
import forsyde.io.java.typed.viewers.platform.runtime.StaticCyclicSchedulerViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface StaticCyclicScheduler
extends AbstractScheduler,
VertexViewer {
    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_RUNTIME_STATICCYCLICSCHEDULER)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_RUNTIME_STATICCYCLICSCHEDULER)) continue;
            return true;
        }
        return false;
    }

    public static Optional<StaticCyclicScheduler> safeCast(Vertex vertex) {
        return StaticCyclicScheduler.conforms(vertex) != false ? Optional.of(new StaticCyclicSchedulerViewer(vertex)) : Optional.empty();
    }

    public static Optional<StaticCyclicScheduler> safeCast(VertexViewer viewer) {
        return StaticCyclicScheduler.conforms(viewer.getViewedVertex()) != false ? Optional.of(new StaticCyclicSchedulerViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static StaticCyclicScheduler enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.PLATFORM_RUNTIME_STATICCYCLICSCHEDULER);
        vertex.ports.addAll(StaticCyclicScheduler.getRequiredPorts());
        for (String key : StaticCyclicScheduler.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, StaticCyclicScheduler.getRequiredProperties().get(key));
        }
        return new StaticCyclicSchedulerViewer(vertex);
    }

    public static StaticCyclicScheduler enforce(VertexViewer viewer) {
        return StaticCyclicScheduler.enforce(viewer.getViewedVertex());
    }
}

