/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.visualization;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.visualization.GreyBoxViewer;
import forsyde.io.java.typed.viewers.visualization.Visualizable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface GreyBox
extends Visualizable,
VertexViewer {
    default public Set<Visualizable> getContainedPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getMultipleNamedPort(model, this.getViewedVertex(), "contained", VertexTrait.VISUALIZATION_VISUALIZABLE, "outgoing").stream().map(v -> Visualizable.safeCast(v).get()).collect(Collectors.toSet());
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.VISUALIZATION_GREYBOX)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.VISUALIZATION_GREYBOX)) continue;
            return true;
        }
        return false;
    }

    public static Optional<GreyBox> safeCast(Vertex vertex) {
        return GreyBox.conforms(vertex) != false ? Optional.of(new GreyBoxViewer(vertex)) : Optional.empty();
    }

    public static Optional<GreyBox> safeCast(VertexViewer viewer) {
        return GreyBox.conforms(viewer.getViewedVertex()) != false ? Optional.of(new GreyBoxViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of("contained");
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static GreyBox enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.VISUALIZATION_GREYBOX);
        vertex.ports.addAll(GreyBox.getRequiredPorts());
        for (String key : GreyBox.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, GreyBox.getRequiredProperties().get(key));
        }
        return new GreyBoxViewer(vertex);
    }

    public static GreyBox enforce(VertexViewer viewer) {
        return GreyBox.enforce(viewer.getViewedVertex());
    }
}

