/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.visualization;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.visualization.PositionedViewer;
import forsyde.io.java.typed.viewers.visualization.Visualizable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Positioned
extends Visualizable,
VertexViewer {
    default public Integer getPositionX() {
        return this.getViewedVertex().getProperties().containsKey("positionX") ? (Integer)this.getViewedVertex().getProperties().get("positionX").unwrap() : null;
    }

    default public void setPositionX(Integer positionX) {
        this.getViewedVertex().getProperties().put("positionX", VertexProperty.create(positionX));
    }

    default public Integer getPositionY() {
        return this.getViewedVertex().getProperties().containsKey("positionY") ? (Integer)this.getViewedVertex().getProperties().get("positionY").unwrap() : null;
    }

    default public void setPositionY(Integer positionY) {
        this.getViewedVertex().getProperties().put("positionY", VertexProperty.create(positionY));
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.VISUALIZATION_POSITIONED)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.VISUALIZATION_POSITIONED)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Positioned> safeCast(Vertex vertex) {
        return Positioned.conforms(vertex) != false ? Optional.of(new PositionedViewer(vertex)) : Optional.empty();
    }

    public static Optional<Positioned> safeCast(VertexViewer viewer) {
        return Positioned.conforms(viewer.getViewedVertex()) != false ? Optional.of(new PositionedViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static Positioned enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.VISUALIZATION_POSITIONED);
        vertex.ports.addAll(Positioned.getRequiredPorts());
        for (String key : Positioned.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, Positioned.getRequiredProperties().get(key));
        }
        return new PositionedViewer(vertex);
    }

    public static Positioned enforce(VertexViewer viewer) {
        return Positioned.enforce(viewer.getViewedVertex());
    }
}

