/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.visualization;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.visualization.VisualizableViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Visualizable
extends VertexViewer {
    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.VISUALIZATION_VISUALIZABLE)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.VISUALIZATION_VISUALIZABLE)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Visualizable> safeCast(Vertex vertex) {
        return Visualizable.conforms(vertex) != false ? Optional.of(new VisualizableViewer(vertex)) : Optional.empty();
    }

    public static Optional<Visualizable> safeCast(VertexViewer viewer) {
        return Visualizable.conforms(viewer.getViewedVertex()) != false ? Optional.of(new VisualizableViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static Visualizable enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.VISUALIZATION_VISUALIZABLE);
        vertex.ports.addAll(Visualizable.getRequiredPorts());
        for (String key : Visualizable.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, Visualizable.getRequiredProperties().get(key));
        }
        return new VisualizableViewer(vertex);
    }

    public static Visualizable enforce(VertexViewer viewer) {
        return Visualizable.enforce(viewer.getViewedVertex());
    }
}

