/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.core;

import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.UCipher;
import com.uopen.cryptionkit.utils.UUtils;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base64;

public class AesCipher
implements UCipher {
    private ReturnType returnType = ReturnType.TYPE_HEX;
    private HashMap<String, String> extendParams;
    private static final String defaultMode = "ECB";
    private static final String defaultPadding = "PKCS7Padding";
    private static final String defaultIv = "0123456789";

    @Override
    public void setReturnDataType(ReturnType mReturnType) {
        this.returnType = mReturnType;
    }

    @Override
    public void setExtendParams(HashMap<String, String> extendParams) {
        this.extendParams = extendParams;
    }

    private String getCustomMode() {
        if (this.extendParams == null) {
            return defaultMode;
        }
        String _mode = this.extendParams.get("MODE");
        if (_mode == null || _mode.length() <= 0) {
            return defaultMode;
        }
        return _mode;
    }

    private String getCustomPadding() {
        if (this.extendParams == null) {
            return defaultPadding;
        }
        String _padding = this.extendParams.get("PADDING");
        if (_padding == null || _padding.length() <= 0) {
            return defaultPadding;
        }
        return _padding;
    }

    private String getCustomIv() {
        if (this.extendParams == null) {
            return defaultIv;
        }
        String _iv = this.extendParams.get("IV");
        if (_iv == null || _iv.length() <= 0) {
            return defaultIv;
        }
        return _iv;
    }

    @Override
    public String encode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.encodeToHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.encodeToBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public String decode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.decodeByHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.decodeByBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.decode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public String encodeToBase64(String key, String content) throws Exception {
        byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
        if (values != null) {
            return new String(Base64.encode((byte[])values), Charset.forName("UTF-8"));
        }
        return null;
    }

    @Override
    public String encodeToHexString(String key, String content) throws Exception {
        byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
        if (values != null) {
            return UUtils.byteArrayToHexString(values);
        }
        return null;
    }

    @Override
    public byte[] encode(String key, byte[] content) throws Exception {
        String _iv = this.getCustomIv();
        IvParameterSpec ivParameterSpec = new IvParameterSpec(_iv.getBytes());
        byte[] raw = key.getBytes("UTF-8");
        SecretKeySpec _key = new SecretKeySpec(raw, "AES");
        String _mode = this.getCustomMode();
        String alt = "AES/" + _mode + "/" + this.getCustomPadding();
        Cipher cipher = Cipher.getInstance(alt);
        if (_mode.equals(defaultMode)) {
            cipher.init(1, _key);
        } else {
            cipher.init(1, (Key)_key, ivParameterSpec);
        }
        byte[] byte_AES = cipher.doFinal(content);
        return byte_AES;
    }

    @Override
    public byte[] decode(String key, byte[] content) throws Exception {
        String _iv = this.getCustomIv();
        IvParameterSpec ivParameterSpec = new IvParameterSpec(_iv.getBytes());
        byte[] raw = key.getBytes("UTF-8");
        SecretKeySpec _key = new SecretKeySpec(raw, "AES");
        String _mode = this.getCustomMode();
        String alt = "AES/" + _mode + "/" + this.getCustomPadding();
        Cipher cipher = Cipher.getInstance(alt);
        if (_mode.equals(defaultMode)) {
            cipher.init(2, _key);
        } else {
            cipher.init(2, (Key)_key, ivParameterSpec);
        }
        byte[] byte_decode = cipher.doFinal(content);
        return byte_decode;
    }

    @Override
    public String decodeByBase64(String key, String contentBase64) throws Exception {
        byte[] values = this.decode(key, Base64.decode((String)contentBase64));
        if (values != null) {
            return new String(values, Charset.forName("UTF-8"));
        }
        return null;
    }

    @Override
    public String decodeByHexString(String key, String contentHex) throws Exception {
        byte[] values = this.decode(key, UUtils.hexStringToByteArray(contentHex));
        if (values != null) {
            return new String(values, Charset.forName("UTF-8"));
        }
        return null;
    }
}

