/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.core;

import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.USignature;
import com.uopen.cryptionkit.utils.StringUtils;
import com.uopen.cryptionkit.utils.UUtils;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DsaSignature
implements USignature {
    private ReturnType returnType = ReturnType.TYPE_HEX;
    public static final String KEY_ALGORITHM = "DSA";
    public static final String SIGNATURE_ALGORITHM = "DSA";

    @Override
    public void setReturnDataType(ReturnType returnType) {
        this.returnType = returnType;
    }

    @Override
    public byte[] sign(byte[] content) {
        return null;
    }

    @Override
    public byte[] signByKey(byte[] privateKey, byte[] content) {
        if (content == null || privateKey == null) {
            return null;
        }
        try {
            KeyFactory factory = KeyFactory.getInstance("DSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
            PrivateKey priKey = factory.generatePrivate(keySpec);
            Signature signature = Signature.getInstance("DSA");
            signature.initSign(priKey);
            signature.update(content);
            return signature.sign();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String signByKey(String privateKey, String content) {
        if (StringUtils.isNull(privateKey) || StringUtils.isNull(content)) {
            throw new RuntimeException("privateKey or content is null");
        }
        byte[] _keys = null;
        _keys = this.returnType == ReturnType.TYPE_BASE64 ? UUtils.convertBase64ToBytes(privateKey) : UUtils.hexStringToByteArray(privateKey);
        try {
            byte[] _datas = content.getBytes("UTF-8");
            byte[] result = this.signByKey(_keys, _datas);
            switch (this.returnType) {
                case TYPE_STRING: {
                    byte[] values = content.getBytes(Charset.forName("UTF-8"));
                    return new String(values);
                }
                case TYPE_BASE64: {
                    return UUtils.convertToBase64(result);
                }
                case TYPE_HEX: {
                    return UUtils.byteArrayToHexString(result);
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean verify(String publicKey, String data, String sign) {
        if (data == null || publicKey == null || StringUtils.isNull(sign)) {
            return false;
        }
        try {
            byte[] _keys = null;
            byte[] _data = data.getBytes("UTF-8");
            byte[] _signBytes = null;
            if (this.returnType == ReturnType.TYPE_BASE64) {
                _keys = UUtils.convertBase64ToBytes(publicKey);
                _signBytes = UUtils.convertBase64ToBytes(sign);
            } else {
                _keys = UUtils.hexStringToByteArray(publicKey);
                _signBytes = UUtils.hexStringToByteArray(sign);
            }
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(_keys);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PublicKey pubKey = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance("DSA");
            signature.initVerify(pubKey);
            signature.update(_data);
            return signature.verify(_signBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String signToString(String content) {
        return null;
    }

    @Override
    public String signToBase64(String content) {
        return null;
    }

    @Override
    public String signToHexString(String content, boolean isUpper) {
        return null;
    }
}

