/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.core;

import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.UCipher;
import com.uopen.cryptionkit.core.Sm3Signature;
import com.uopen.cryptionkit.utils.UUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.HashMap;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Base64;

public class Sm2Cipher
implements UCipher {
    private ReturnType returnType = ReturnType.TYPE_HEX;
    public static String[] ecc_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    public final BigInteger ecc_p = new BigInteger(ecc_param[0], 16);
    public final BigInteger ecc_a = new BigInteger(ecc_param[1], 16);
    public final BigInteger ecc_b = new BigInteger(ecc_param[2], 16);
    public final BigInteger ecc_n = new BigInteger(ecc_param[3], 16);
    public final BigInteger ecc_gx = new BigInteger(ecc_param[4], 16);
    public final BigInteger ecc_gy = new BigInteger(ecc_param[5], 16);
    public final ECCurve ecc_curve;
    public final ECPoint ecc_point_g;
    public final ECDomainParameters ecc_bc_spec;
    public final ECKeyPairGenerator ecc_key_pair_generator;
    public final ECFieldElement ecc_gx_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_gx);
    public final ECFieldElement ecc_gy_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_gy);

    public Sm2Cipher() {
        this.ecc_curve = new ECCurve.Fp(this.ecc_p, this.ecc_a, this.ecc_b);
        this.ecc_point_g = new ECPoint.Fp(this.ecc_curve, this.ecc_gx_fieldelement, this.ecc_gy_fieldelement);
        this.ecc_bc_spec = new ECDomainParameters(this.ecc_curve, this.ecc_point_g, this.ecc_n);
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init((KeyGenerationParameters)ecc_ecgenparam);
    }

    @Override
    public void setReturnDataType(ReturnType mReturnType) {
        this.returnType = mReturnType;
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    @Override
    public void setExtendParams(HashMap<String, String> extendParams) {
    }

    @Override
    public byte[] encode(String key, byte[] content) throws Exception {
        if (key == null || content == null) {
            return null;
        }
        byte[] source = new byte[content.length];
        System.arraycopy(content, 0, source, 0, content.length);
        Cipher cipher = new Cipher();
        byte[] _key = null;
        _key = this.returnType.equals((Object)ReturnType.TYPE_BASE64) ? UUtils.convertBase64ToBytes(key) : UUtils.hexStringToBytes(key);
        ECPoint userKey = this.ecc_curve.decodePoint(_key);
        ECPoint c1 = cipher.Init_enc(userKey);
        cipher.Encrypt(source);
        byte[] encode = c1.getEncoded();
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);
        ByteBuffer byteBuffer = ByteBuffer.allocate(encode.length + source.length + c3.length);
        byteBuffer.put(encode);
        byteBuffer.put(source);
        byteBuffer.put(c3);
        return byteBuffer.array();
    }

    @Override
    public String encode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.encodeToHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.encodeToBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public String encodeToBase64(String key, String content) throws Exception {
        byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
        if (values != null) {
            return new String(Base64.encode((byte[])values), Charset.forName("UTF-8"));
        }
        return null;
    }

    @Override
    public String encodeToHexString(String key, String content) throws Exception {
        byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
        if (values != null) {
            return UUtils.byteArrayToHexString(values);
        }
        return null;
    }

    @Override
    public byte[] decode(String key, byte[] content) throws Exception {
        if (content == null || key == null) {
            return null;
        }
        String data = UUtils.byteToHex(content);
        byte[] c1Bytes = UUtils.hexToByte(data.substring(0, 130));
        int c2Len = content.length - 97;
        byte[] c2 = UUtils.hexToByte(data.substring(130, 130 + 2 * c2Len));
        byte[] c3 = UUtils.hexToByte(data.substring(130 + 2 * c2Len, 194 + 2 * c2Len));
        byte[] _key = null;
        _key = this.returnType.equals((Object)ReturnType.TYPE_BASE64) ? UUtils.convertBase64ToBytes(key) : UUtils.hexStringToBytes(key);
        BigInteger userD = new BigInteger(1, _key);
        ECPoint c1 = this.ecc_curve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.Init_dec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);
        return c2;
    }

    @Override
    public String decode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.decodeByHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.decodeByBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.decode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public String decodeByBase64(String key, String contentBase64) throws Exception {
        byte[] values = this.decode(key, Base64.decode((String)contentBase64));
        if (values != null) {
            return new String(values, Charset.forName("UTF-8"));
        }
        return null;
    }

    @Override
    public String decodeByHexString(String key, String contentHex) throws Exception {
        byte[] values = this.decode(key, UUtils.hexStringToByteArray(contentHex));
        if (values != null) {
            return new String(values, Charset.forName("UTF-8"));
        }
        return null;
    }

    public class Cipher {
        private int ct = 1;
        private ECPoint p2;
        private Sm3Signature sm3keybase;
        private Sm3Signature sm3c3;
        private byte[] key = new byte[32];
        private byte keyOff = 0;

        private void Reset() {
            this.sm3keybase = new Sm3Signature();
            this.sm3c3 = new Sm3Signature();
            byte[] p = UUtils.byteConvert32Bytes(this.p2.getX().toBigInteger());
            this.sm3keybase.update(p, 0, p.length);
            this.sm3c3.update(p, 0, p.length);
            p = UUtils.byteConvert32Bytes(this.p2.getY().toBigInteger());
            this.sm3keybase.update(p, 0, p.length);
            this.ct = 1;
            this.NextKey();
        }

        private void NextKey() {
            Sm3Signature sm3keycur = new Sm3Signature(this.sm3keybase);
            sm3keycur.update((byte)(this.ct >> 24 & 0xFF));
            sm3keycur.update((byte)(this.ct >> 16 & 0xFF));
            sm3keycur.update((byte)(this.ct >> 8 & 0xFF));
            sm3keycur.update((byte)(this.ct & 0xFF));
            sm3keycur.doFinal(this.key, 0);
            this.keyOff = 0;
            ++this.ct;
        }

        public ECPoint Init_enc(ECPoint userKey) {
            AsymmetricCipherKeyPair key = Sm2Cipher.this.ecc_key_pair_generator.generateKeyPair();
            ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
            ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
            BigInteger k = ecpriv.getD();
            ECPoint c1 = ecpub.getQ();
            this.p2 = userKey.multiply(k);
            this.Reset();
            return c1;
        }

        public void Encrypt(byte[] data) {
            this.sm3c3.update(data, 0, data.length);
            int i = 0;
            while (i < data.length) {
                if (this.keyOff == this.key.length) {
                    this.NextKey();
                }
                int n = i++;
                byte by = this.keyOff;
                this.keyOff = (byte)(by + 1);
                data[n] = (byte)(data[n] ^ this.key[by]);
            }
        }

        public void Init_dec(BigInteger userD, ECPoint c1) {
            this.p2 = c1.multiply(userD);
            this.Reset();
        }

        public void Decrypt(byte[] data) {
            int i = 0;
            while (i < data.length) {
                if (this.keyOff == this.key.length) {
                    this.NextKey();
                }
                int n = i++;
                byte by = this.keyOff;
                this.keyOff = (byte)(by + 1);
                data[n] = (byte)(data[n] ^ this.key[by]);
            }
            this.sm3c3.update(data, 0, data.length);
        }

        public void Dofinal(byte[] c3) {
            byte[] p = UUtils.byteConvert32Bytes(this.p2.getY().toBigInteger());
            this.sm3c3.update(p, 0, p.length);
            this.sm3c3.doFinal(c3, 0);
            this.Reset();
        }
    }
}

