/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.core;

import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.UCipher;
import com.uopen.cryptionkit.utils.UUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base64;

public class TripleDesCipher
implements UCipher {
    private static final String Algorithm = "DESede";
    private ReturnType returnType = ReturnType.TYPE_HEX;

    @Override
    public void setReturnDataType(ReturnType mReturnType) {
        this.returnType = mReturnType;
    }

    @Override
    public void setExtendParams(HashMap<String, String> extendParams) {
    }

    @Override
    public String encode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.encodeToHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.encodeToBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public String decode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.decodeByHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.decodeByBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.decode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public byte[] encode(String key, byte[] content) throws Exception {
        if (key == null || content == null) {
            return null;
        }
        SecretKeySpec deskey = new SecretKeySpec(TripleDesCipher.build3DesKey(key), Algorithm);
        Cipher c1 = Cipher.getInstance(Algorithm);
        c1.init(1, deskey);
        return c1.doFinal(content);
    }

    @Override
    public String encodeToBase64(String key, String content) throws Exception {
        byte[] contents = content.getBytes(Charset.forName("UTF-8"));
        contents = this.encode(key, contents);
        return new String(Base64.encode((byte[])contents));
    }

    @Override
    public String encodeToHexString(String key, String content) throws Exception {
        byte[] contents = content.getBytes(Charset.forName("UTF-8"));
        contents = this.encode(key, contents);
        return UUtils.byteArrayToHexString(contents);
    }

    @Override
    public byte[] decode(String key, byte[] content) throws Exception {
        if (key == null || content == null) {
            return null;
        }
        SecretKeySpec deskey = new SecretKeySpec(TripleDesCipher.build3DesKey(key), Algorithm);
        Cipher c1 = Cipher.getInstance(Algorithm);
        c1.init(2, deskey);
        return c1.doFinal(content);
    }

    @Override
    public String decodeByBase64(String key, String contentBase64) throws Exception {
        byte[] contents = this.decode(key, Base64.decode((String)contentBase64));
        if (contents != null) {
            return new String(contents);
        }
        return null;
    }

    @Override
    public String decodeByHexString(String key, String contentHex) throws Exception {
        byte[] contents = this.decode(key, UUtils.hexStringToByteArray(contentHex));
        return new String(contents);
    }

    private static byte[] build3DesKey(String keyStr) throws UnsupportedEncodingException {
        byte[] key = new byte[24];
        byte[] temp = keyStr.getBytes("UTF-8");
        if (temp.length <= key.length) {
            System.arraycopy(temp, 0, key, 0, temp.length);
        } else {
            System.arraycopy(temp, 0, key, 0, key.length);
        }
        return key;
    }
}

