/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import pl.project13.core.PropertiesFilterer;
import pl.project13.core.cibuild.AwsCodeBuildBuildServerData;
import pl.project13.core.cibuild.AzureDevOpsBuildServerData;
import pl.project13.core.cibuild.BambooBuildServerData;
import pl.project13.core.cibuild.BitbucketBuildServerData;
import pl.project13.core.cibuild.CircleCiBuildServerData;
import pl.project13.core.cibuild.GitHubBuildServerData;
import pl.project13.core.cibuild.GitlabBuildServerData;
import pl.project13.core.cibuild.HudsonJenkinsBuildServerData;
import pl.project13.core.cibuild.TeamCityBuildServerData;
import pl.project13.core.cibuild.TravisBuildServerData;
import pl.project13.core.cibuild.UnknownBuildServerData;
import pl.project13.core.log.LogInterface;
import pl.project13.core.util.PropertyManager;

public abstract class BuildServerDataProvider {
    final LogInterface log;
    final Map<String, String> env;
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ssZ";
    private String dateFormatTimeZone = null;
    private String prefixDot = "";
    private List<String> excludeProperties = null;
    private List<String> includeOnlyProperties = null;
    private Map<String, Supplier<String>> additionalProperties = new HashMap<String, Supplier<String>>();
    protected static final String BRANCH_REF_PREFIX = "refs/heads/";
    protected static final String PULL_REQUEST_REF_PREFIX = "refs/pull/";
    protected static final String TAG_REF_PREFIX = "refs/tags/";

    BuildServerDataProvider(@Nonnull LogInterface log, @Nonnull Map<String, String> env) {
        this.log = log;
        this.env = env;
    }

    public BuildServerDataProvider setDateFormat(@Nonnull String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public BuildServerDataProvider setDateFormatTimeZone(@Nonnull String dateFormatTimeZone) {
        this.dateFormatTimeZone = dateFormatTimeZone;
        return this;
    }

    public BuildServerDataProvider setPrefixDot(@Nonnull String prefixDot) {
        this.prefixDot = prefixDot;
        return this;
    }

    public BuildServerDataProvider setExcludeProperties(List<String> excludeProperties) {
        this.excludeProperties = excludeProperties;
        return this;
    }

    public BuildServerDataProvider setIncludeOnlyProperties(List<String> includeOnlyProperties) {
        this.includeOnlyProperties = includeOnlyProperties;
        return this;
    }

    public BuildServerDataProvider setAdditionalProperties(Map<String, Supplier<String>> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public static BuildServerDataProvider getBuildServerProvider(@Nonnull Map<String, String> env, @Nonnull LogInterface log) {
        if (BambooBuildServerData.isActiveServer(env)) {
            return new BambooBuildServerData(log, env);
        }
        if (GitlabBuildServerData.isActiveServer(env)) {
            return new GitlabBuildServerData(log, env);
        }
        if (HudsonJenkinsBuildServerData.isActiveServer(env)) {
            return new HudsonJenkinsBuildServerData(log, env);
        }
        if (TeamCityBuildServerData.isActiveServer(env)) {
            return new TeamCityBuildServerData(log, env);
        }
        if (TravisBuildServerData.isActiveServer(env)) {
            return new TravisBuildServerData(log, env);
        }
        if (AzureDevOpsBuildServerData.isActiveServer(env)) {
            return new AzureDevOpsBuildServerData(log, env);
        }
        if (CircleCiBuildServerData.isActiveServer(env)) {
            return new CircleCiBuildServerData(log, env);
        }
        if (GitHubBuildServerData.isActiveServer(env)) {
            return new GitHubBuildServerData(log, env);
        }
        if (AwsCodeBuildBuildServerData.isActiveServer(env)) {
            return new AwsCodeBuildBuildServerData(log, env);
        }
        if (BitbucketBuildServerData.isActiveServer(env)) {
            return new BitbucketBuildServerData(log, env);
        }
        return new UnknownBuildServerData(log, env);
    }

    public void loadBuildData(@Nonnull Properties properties, @Nullable Date reproducibleBuildOutputTimestamp) {
        this.loadBuildVersionAndTimeData(properties, reproducibleBuildOutputTimestamp);
        this.loadBuildHostData(properties);
        this.loadBuildNumber(properties);
    }

    abstract void loadBuildNumber(@Nonnull Properties var1);

    public abstract String getBuildBranch();

    private void loadBuildVersionAndTimeData(@Nonnull Properties properties, @Nullable Date reproducibleBuildOutputTimestamp) {
        Supplier<String> buildTimeSupplier = () -> {
            Date buildDate = reproducibleBuildOutputTimestamp == null ? new Date() : reproducibleBuildOutputTimestamp;
            SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
            if (this.dateFormatTimeZone != null) {
                smf.setTimeZone(TimeZone.getTimeZone(this.dateFormatTimeZone));
            }
            return smf.format(buildDate);
        };
        this.maybePut(properties, "build.time", buildTimeSupplier);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Supplier<String>> e : this.additionalProperties.entrySet()) {
                this.maybePut(properties, e.getKey(), e.getValue());
            }
        }
    }

    private void loadBuildHostData(@Nonnull Properties properties) {
        Supplier<String> buildHostSupplier = () -> {
            String buildHost = null;
            try {
                buildHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.log.info(String.format("Unable to get build host, skipping property %s. Error message: %s", "build.host", e.getMessage()));
            }
            return buildHost;
        };
        this.maybePut(properties, "build.host", buildHostSupplier);
    }

    protected void maybePut(@Nonnull Properties properties, @Nonnull String key, Supplier<String> supplier) {
        String keyWithPrefix = this.prefixDot + key;
        if (properties.stringPropertyNames().contains(keyWithPrefix)) {
            String propertyValue = properties.getProperty(keyWithPrefix);
            this.log.info(String.format("Using cached %s with value %s", keyWithPrefix, propertyValue));
        } else if (PropertiesFilterer.isIncluded(keyWithPrefix, this.includeOnlyProperties, this.excludeProperties)) {
            String propertyValue = supplier.get();
            this.log.info(String.format("Collected %s with value %s", keyWithPrefix, propertyValue));
            PropertyManager.putWithoutPrefix(properties, keyWithPrefix, propertyValue);
        }
    }
}

