/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.container.impl.bootstrap;

import java.util.LinkedHashSet;
import org.brijframework.container.Container;
import org.brijframework.container.bootstrap.BootstrapContainer;
import org.brijframework.container.impl.AbstractContainer;
import org.brijframework.factories.Factory;
import org.brijframework.factories.bootstrap.BootstrapFactory;
import org.brijframework.support.ordering.DepandOn;
import org.brijframework.support.ordering.OrderOn;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.printer.LoggerConsole;
import org.brijframework.util.reflect.AnnotationUtil;

public abstract class AbstractBootstrapContainer
extends AbstractContainer
implements BootstrapContainer {
    private LinkedHashSet<Class<? extends BootstrapFactory<?, ?>>> bootstrapFactories = new LinkedHashSet();

    public Container loadContainer() {
        LoggerConsole.screen((String)("BootstrapContainer -> " + this.getClass().getSimpleName()), (String)("Loading the bootstrap container for " + this.getClass().getSimpleName()));
        this.getOrderOnSortedFactoryList(this.getBootstrapFactories()).forEach(metaFactory -> this.loadFactory((Class<? extends Factory<?, ?>>)metaFactory));
        LoggerConsole.screen((String)("BootstrapContainer -> " + this.getClass().getSimpleName()), (String)("Loaded the bootstrap container for " + this.getClass().getSimpleName()));
        return this;
    }

    protected LinkedHashSet<Class<? extends BootstrapFactory<?, ?>>> getBootstrapFactories() {
        return this.bootstrapFactories;
    }

    protected void register(Class<? extends BootstrapFactory<?, ?>> container) {
        Assertion.notNull(container, (String)"ModuleFactory class should not be null.");
        this.getBootstrapFactories().add(container);
    }

    public LinkedHashSet<Class<? extends BootstrapFactory<?, ?>>> getDepandOnSortedFactoryList(LinkedHashSet<Class<? extends BootstrapFactory<?, ?>>> linkedHashSet) {
        LinkedHashSet list = new LinkedHashSet();
        linkedHashSet.stream().sorted((c1, c2) -> {
            if (c1.isAnnotationPresent(DepandOn.class)) {
                return -1;
            }
            if (c2.isAnnotationPresent(DepandOn.class)) {
                return 1;
            }
            return 0;
        }).forEach(factory -> this.fillDepandOnFactory(list, (Class<? extends BootstrapFactory<?, ?>>)factory));
        return list;
    }

    private void fillDepandOnFactory(LinkedHashSet<Class<? extends BootstrapFactory<?, ?>>> list, Class<? extends BootstrapFactory<?, ?>> factory) {
        if (factory == null) {
            return;
        }
        if (factory.isAnnotationPresent(DepandOn.class)) {
            DepandOn depandOn = factory.getAnnotation(DepandOn.class);
            this.fillDepandOnFactory(list, depandOn.depand());
        }
        if (!list.contains(factory)) {
            list.add(factory);
        }
    }

    public Iterable<Class<? extends BootstrapFactory<?, ?>>> getOrderOnSortedFactoryList(LinkedHashSet<Class<? extends BootstrapFactory<?, ?>>> classList) {
        LinkedHashSet list = new LinkedHashSet();
        classList.stream().filter(c -> c.isAnnotationPresent(OrderOn.class)).sorted((c1, c2) -> {
            OrderOn orderOn1 = (OrderOn)AnnotationUtil.getAnnotation((Class)c1, OrderOn.class);
            OrderOn orderOn2 = (OrderOn)AnnotationUtil.getAnnotation((Class)c2, OrderOn.class);
            return Integer.compare(orderOn1.value(), orderOn2.value());
        }).forEach(factory -> list.add((Class<? extends BootstrapFactory<?, ?>>)factory));
        classList.stream().filter(c -> !c.isAnnotationPresent(OrderOn.class)).forEach(factory -> list.add((Class<? extends BootstrapFactory<?, ?>>)factory));
        return list;
    }

    public boolean containsObject(Object key) {
        return false;
    }
}

