/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.container.impl;

import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.brijframework.container.Container;
import org.brijframework.context.Context;
import org.brijframework.group.Group;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.printer.LoggerConsole;

public interface DefaultContainer
extends Container {
    default public Group add(Object groupKey, Group group) {
        Assertion.notNull((Object)groupKey, (String)"this is required . it must not be null or empty -> groupKey");
        Assertion.notNull((Object)group, (String)"this arg is required; it must not be null -> group");
        Assertion.isTrue((this.getCache().get(groupKey) != null ? 1 : 0) != 0, (String)("Key allready conatains . don't try to modify with key values->" + groupKey));
        LoggerConsole.screen((String)"Group", (String)("Group registered with id :" + groupKey));
        return this.getCache().put(groupKey, group);
    }

    default public Group update(Object groupKey, Group group) {
        Assertion.notNull((Object)groupKey, (String)"this is required . it must not be null or empty -> groupKey");
        Assertion.isTrue((this.getCache().get(groupKey) == null ? 1 : 0) != 0, (String)("Key not conatains . don't try to modify with key values->" + groupKey));
        LoggerConsole.screen((String)"Group", (String)("Group changed with id :" + groupKey));
        return this.getCache().replace(groupKey, group);
    }

    default public Group remove(Object groupKey) {
        Assertion.notNull((Object)groupKey, (String)"this is required . it must not be null or empty -> groupKey");
        Assertion.isTrue((this.getCache().get(groupKey) != null ? 1 : 0) != 0, (String)("Key not conatains . don't try to modify with key values->" + groupKey));
        LoggerConsole.screen((String)"Group", (String)("Group removed with id :" + groupKey));
        return (Group)this.getCache().remove(groupKey);
    }

    default public Group get(Object groupKey) {
        Assertion.notNull((Object)groupKey, (String)"this is required . it must not be null or empty -> groupKey");
        return (Group)this.getCache().get(groupKey);
    }

    default public Group search(Object groupKey) {
        Assertion.notNull((Object)groupKey, (String)"this is required . it must not be null or empty -> groupKey");
        if (this.getCache().get(groupKey) != null) {
            return (Group)this.getCache().get(groupKey);
        }
        Enumeration enumeration = this.getCache().elements();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            if (!groupKey.toString().equalsIgnoreCase("" + group.getGroupKey())) continue;
            return group;
        }
        return null;
    }

    default public <T> T add(Object groupKey, Object dataKey, T object) {
        Assertion.notNull((Object)groupKey, (String)"this is required . it must not be null or empty -> groupKey");
        Group group = this.load(groupKey);
        Assertion.isTrue((this.getCache().get(groupKey) == null ? 1 : 0) != 0, (String)("Key not conatains . don't try to modify with key values " + groupKey));
        return (T)group.add(dataKey, object);
    }

    default public <T> T remove(Object groupKey, Object dataKey) {
        Assertion.notNull((Object)groupKey, (String)"this is required . it must not be null or empty -> groupKey");
        Assertion.notNull((Object)dataKey, (String)"this is required . it must not be null or empty -> dataKey");
        Assertion.isTrue((this.getCache().get(groupKey) != null ? 1 : 0) != 0, (String)"Key not conatains . don't try to modify with key values");
        return (T)((Group)this.getCache().get(groupKey)).remove(dataKey);
    }

    default public <T> T update(Object groupKey, Object dataKey, T object) {
        Assertion.notNull((Object)groupKey, (String)"this is required . it must not be null or empty -> groupKey");
        Assertion.notNull((Object)dataKey, (String)"this is required . it must not be null or empty -> dataKey");
        Assertion.isTrue((this.getCache().get(groupKey) != null ? 1 : 0) != 0, (String)"Key not conatains . don't try to modify with key values");
        return (T)((Group)this.getCache().get(groupKey)).update(dataKey, object);
    }

    default public <T> T get(Object groupKey, Object dataKey) {
        Assertion.notNull((Object)groupKey, (String)"this is required . it must not be null or empty -> groupKey");
        Assertion.notNull((Object)dataKey, (String)"this is required . it must not be null or empty -> dataKey");
        Assertion.isTrue((this.getCache().get(groupKey) != null ? 1 : 0) != 0, (String)"Key not conatains . don't try to modify with key values");
        return (T)((Group)this.getCache().get(groupKey)).get(dataKey);
    }

    default public Group merge(Object groupKey, Group group) {
        Group findGroup = this.get(groupKey);
        if (findGroup != null) {
            return findGroup;
        }
        return this.add(groupKey, group);
    }

    default public <T> T search(Object groupKey, Object dataKey) {
        Assertion.notNull((Object)groupKey, (String)"this is required . it must not be null or empty -> groupKey");
        Assertion.notNull((Object)dataKey, (String)"this is required . it must not be null or empty -> dataKey");
        Group group = this.search(groupKey);
        Assertion.notNull((Object)group, (String)"Key not found . don't try to find with key values -> groupKey");
        return (T)group.find(dataKey);
    }

    default public <T> T search(Object groupKey, String parentID, Class<?> type) {
        Group group = this.get(groupKey);
        if (group == null) {
            return null;
        }
        return (T)group.find(parentID, type);
    }

    default public <T> T find(Object find) {
        Assertion.notNull((Object)find, (String)"this is required . it must not be null or empty -> find");
        Set enumeration = this.getCache().entrySet();
        for (Map.Entry entry : enumeration) {
            Object data = ((Group)entry.getValue()).find(find);
            if (data == null) continue;
            return (T)data;
        }
        return null;
    }

    default public Container reLoadContainer() {
        this.clearContainer();
        return this.loadContainer();
    }

    default public Container clearContainer() {
        this.getCache().clear();
        return this;
    }

    public void setContext(Context var1);
}

