/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.group.impl;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.brijframework.group.Group;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.validator.ValidationUtil;

public interface DefaultGroup
extends Group {
    public static final String DEFAULT = "default";

    default public boolean containsKey(Object dataKey) {
        return this.getCache().containsKey(dataKey);
    }

    default public <T> T add(Object dataKey, T value) {
        Assertion.notNull((Object)dataKey, (String)"this is required . it must not be null or empty left");
        Assertion.notNull(value, (String)"this is required . it must not be null or empty right");
        Assertion.isTrue((this.getCache().get(dataKey) != null ? 1 : 0) != 0, (String)("Key allready conatains . don't try to modify with key values " + dataKey));
        this.getCache().put(dataKey, value);
        return value;
    }

    default public <T> T marge(Object dataKey, T value) {
        Assertion.notNull((Object)dataKey, (String)"this is required . it must not be null or empty left");
        Assertion.notNull(value, (String)"this is required . it must not be null or empty right");
        this.getCache().put(dataKey, value);
        return value;
    }

    default public <T> T remove(Object dataKey) {
        Assertion.notNull((Object)dataKey, (String)"this is required . it must not be null or empty");
        return (T)this.getCache().remove(dataKey);
    }

    default public <T> T get(Object dataKey) {
        Assertion.notNull((Object)dataKey, (String)"this is required . it must not be null or empty");
        dataKey = ValidationUtil.isEmptyObject((Object)dataKey) ? DEFAULT : dataKey;
        return (T)this.getCache().get(dataKey);
    }

    default public <T> T getIgnoreCase(Object dataKey) {
        Assertion.notNull((Object)dataKey, (String)"this is required . it must not be null or empty");
        dataKey = ValidationUtil.isEmptyObject((Object)dataKey) ? DEFAULT : dataKey;
        Set entries = this.getCache().entrySet();
        for (Map.Entry entry : entries) {
            if (!entry.getKey().toString().equalsIgnoreCase(dataKey.toString())) continue;
            return (T)entry.getValue();
        }
        return null;
    }

    default public <T> T update(Object dataKey, T value) {
        Assertion.notNull((Object)dataKey, (String)"this is required . it must not be null or empty");
        return this.getCache().replace(dataKey, value);
    }

    default public <T> T find(Object dataKey) {
        T search = this.get(dataKey = ValidationUtil.isEmptyObject((Object)dataKey) ? DEFAULT : dataKey);
        if (search != null) {
            return search;
        }
        Set enumeration = this.getCache().entrySet();
        for (Map.Entry entry : enumeration) {
            if (!entry.getKey().equals(dataKey)) continue;
            return (T)entry.getValue();
        }
        return null;
    }

    default public <T> T indexOfValue(int i) {
        return (T)this.getCache().values().toArray()[i];
    }

    default public <T> T indexOfKey(int i) {
        return (T)((ConcurrentHashMap.CollectionView)((Object)this.getCache().keySet())).toArray()[i];
    }
}

