/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.bean.factories.asm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.brijframework.bean.definition.BeanDefinition;
import org.brijframework.bean.factories.BeanScopeFactory;
import org.brijframework.bean.factories.definition.impl.BeanDefinitionFactoryImpl;
import org.brijframework.bean.scope.BeanScope;
import org.brijframework.bean.scope.monitor.factories.PrototypeScopeMonitorFactroy;
import org.brijframework.bean.scope.monitor.factories.RequestScopeMonitorFactroy;
import org.brijframework.bean.scope.monitor.factories.SessionScopeMonitorFactroy;
import org.brijframework.bean.util.BeanScopeUtil;
import org.brijframework.container.Container;
import org.brijframework.factories.impl.AbstractFactory;
import org.brijframework.group.Group;
import org.brijframework.util.accessor.LogicAccessorUtil;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.printer.LoggerConsole;
import org.brijframework.util.reflect.ClassUtil;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.reflect.MethodUtil;
import org.brijframework.util.support.ReflectionAccess;
import org.brijframework.util.text.StringUtil;

public abstract class AbstractBeanScopeFactory<K, T extends BeanScope>
extends AbstractFactory<K, T>
implements BeanScopeFactory<K, T> {
    @Override
    public boolean contains(K key) {
        return this.find(key) != null;
    }

    @Override
    public T getBeanScopeForObject(Object object) {
        for (BeanScope beanScope : this.getCache().values()) {
            if (object != beanScope.getScopeObject()) continue;
            return (T)beanScope;
        }
        Container container = this.getContainer();
        if (container == null) {
            return null;
        }
        for (Group group : container.getCache().values()) {
            for (Object objectScope : group.getCache().values()) {
                BeanScope beanScope;
                if (!(objectScope instanceof BeanScope) || object != (beanScope = (BeanScope)objectScope).getScopeObject()) continue;
                return (T)beanScope;
            }
        }
        return null;
    }

    @Override
    public Object getBeanObject(String key) {
        T beanScope = this.getBeanScope(key);
        if (beanScope != null) {
            return ((BeanScope)beanScope).getScopeObject();
        }
        return null;
    }

    @Override
    public BeanDefinition getBeanDefinitionOfObject(Object object) {
        Object beanScopeOfObject = this.getBeanScopeForObject(object);
        return beanScopeOfObject != null ? ((BeanScope)beanScopeOfObject).getBeanDefinition() : null;
    }

    public T getBeanScope(K name) {
        BeanDefinition beanMetaData = BeanDefinitionFactoryImpl.getFactory().find(name.toString());
        if (beanMetaData == null) {
            return null;
        }
        String uniqueID = this.getUniqueID(beanMetaData);
        System.out.println("uniqueID=" + uniqueID);
        return this.getBeanScope(beanMetaData, uniqueID);
    }

    public T getBeanScope(BeanDefinition definition, K uniqueID) {
        BeanScope find = (BeanScope)this.find(uniqueID);
        if (find != null) {
            return (T)find;
        }
        BeanScope register = this.register(uniqueID, definition);
        return (T)register;
    }

    public BeanScope register(K key, BeanDefinition definition) {
        BeanScope find = (BeanScope)this.find(key);
        if (find != null) {
            return find;
        }
        T beanScope = this.createBeanScope(definition);
        ((BeanScope)beanScope).setBeanDefinition(definition);
        Object scopeObject = this.createBean(definition);
        ((BeanScope)beanScope).setScopeObject(scopeObject);
        ((BeanScope)beanScope).setId(key.toString());
        this.register(key, beanScope);
        BeanScopeUtil.setPropertiesPath(this, scopeObject, definition.getProperties(), true, true);
        return beanScope;
    }

    protected abstract T createBeanScope(BeanDefinition var1);

    public String getUniqueID(BeanDefinition datainfo) {
        switch (datainfo.getScope()) {
            case SINGLETON: {
                return datainfo.getId();
            }
            case SESSION: {
                return datainfo.getId() + SessionScopeMonitorFactroy.factory().currentService().getId();
            }
            case REQUEST: {
                return datainfo.getId() + RequestScopeMonitorFactroy.factory().currentService().getId();
            }
            case PROTOTYPE: {
                return datainfo.getId() + PrototypeScopeMonitorFactroy.factory().currentService().getId();
            }
        }
        return datainfo.getId();
    }

    private Object createBean(BeanDefinition datainfo) {
        if (StringUtil.isNonEmpty((String)datainfo.getFactoryClass())) {
            Class factory = ClassUtil.getClass((String)datainfo.getFactoryClass());
            Object current = null;
            for (String key : datainfo.getFactoryMethod().split("\\.")) {
                Method findMethod = MethodUtil.findMethod((Class)factory, (String)key, (ReflectionAccess)ReflectionAccess.PRIVATE, (Class[])new Class[0]);
                current = LogicAccessorUtil.callLogic(current, (Method)findMethod, (Object[])new Object[0]);
            }
            return current;
        }
        return InstanceUtil.getInstance((Class)datainfo.getOwner().getType(), (Object[])datainfo.getConstructor().getValues());
    }

    public void loadContainer(K key, T value) {
        if (this.getContainer() == null) {
            return;
        }
        Group group = this.getContainer().load((Object)((BeanScope)value).getBeanDefinition().getOwner().getName());
        if (!group.containsKey((Object)((BeanScope)value).getId())) {
            group.add(key, value);
        } else {
            group.update(key, value);
        }
    }

    @Override
    public T find(Class<? extends Object> beanClass) {
        List<T> findAll = this.findAll(beanClass);
        if (findAll.isEmpty()) {
            return null;
        }
        Assertion.isTrue((findAll.size() > 1 ? 1 : 0) != 0, (String)(beanClass.getSimpleName() + " nonunique bean exist."));
        return (T)((BeanScope)findAll.get(0));
    }

    @Override
    public List<T> findAll(Class<? extends Object> beanClass) {
        ArrayList<BeanScope> list = new ArrayList<BeanScope>();
        for (BeanScope beanScope : this.getCache().values()) {
            if (!beanClass.isAssignableFrom(beanScope.getBeanDefinition().getOwner().getType())) continue;
            list.add(beanScope);
        }
        return list;
    }

    protected void preregister(K key, T value) {
        LoggerConsole.screen((String)"Bean : ", (String)("BeanScope :" + key));
    }

    protected void postregister(K key, T value) {
    }
}

