/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.resources.files.xml;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.brijframework.resources.Resource;
import org.brijframework.resources.files.json.JsonResource;
import org.json.JSONException;
import org.json.XML;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XmlResource
extends JsonResource {
    private String xmlresource;

    public XmlResource(String path) {
        super(path);
    }

    public XmlResource(File path) {
        super(path);
    }

    public XmlResource(Resource metaResource) {
        super(metaResource);
    }

    public XmlResource(String resource, boolean isPath) {
        if (isPath) {
            this.setPath(resource);
        } else {
            this.setXmlResource(resource);
        }
    }

    public XmlResource() {
    }

    @Override
    public String getJsonResource() {
        try {
            return this.keyReplace(XML.toJSONObject((String)this.getXmlResource()), "content", "value").toString();
        }
        catch (JSONException e) {
            System.err.println(this.getXmlResource());
            return null;
        }
    }

    public String getXmlResource() {
        if (this.xmlresource == null) {
            this.xmlresource = this.getResource();
        }
        return this.xmlresource;
    }

    public void setXmlResource(String xmlresource) {
        this.xmlresource = xmlresource;
    }

    public boolean isValidXml() {
        return this.getXmlResource() != null && this.getXmlResource() != "" && this.getXmlResource().trim().startsWith("<") && this.getXmlResource().trim().endsWith(">");
    }

    public Document document() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(this.getXmlResource())));
    }

    public String source() throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(this.document());
        StreamResult result = new StreamResult(new StringWriter());
        transformer.transform(source, result);
        return result.getWriter().toString();
    }
}

