/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.casting;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.brijframework.util.formatter.PatternUtil;
import org.brijframework.util.validator.ValidationUtil;

public abstract class DateUtil {
    public static final int DAY_UNITS = 1;
    public static final int MONTH_UNITS = 2;
    public static final int YEAR_UNITS = 3;
    static int[] month = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static int isLeap(int y) {
        if (y % 400 == 0 || y % 100 != 0 && y % 4 == 0) {
            return 29;
        }
        return 28;
    }

    public static boolean dateValidate(int d, int m, int y) {
        DateUtil.month[2] = DateUtil.isLeap(y);
        return m >= 0 && m <= 12 && d >= 0 && d <= month[m] && y >= 0 && y <= 9999;
    }

    public static int NumberOfDays(int d, int m, int y) {
        int i;
        int dn = 0;
        DateUtil.month[2] = DateUtil.isLeap(y);
        for (i = 1; i < m; ++i) {
            dn += month[i];
        }
        dn += d;
        for (i = 1; i < y; ++i) {
            if (DateUtil.isLeap(i) == 29) {
                dn += 366;
                continue;
            }
            dn += 365;
        }
        return dn;
    }

    public static long dateDifference(String inputString1, String inputString2, String format) {
        SimpleDateFormat myFormat = new SimpleDateFormat(format);
        Date date1 = null;
        Date date2 = null;
        try {
            date1 = myFormat.parse(inputString1);
            date2 = myFormat.parse(inputString2);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        long diff = date2.getTime() - date1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }

    public static Date dateObject(String inputString, String format) {
        SimpleDateFormat myFormat = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = myFormat.parse(inputString);
        }
        catch (ParseException e) {
            System.err.println("WARN: unexpected object in Object.dateValue(): " + inputString);
        }
        return date;
    }

    public static Date dateObject(Object dateStr) {
        if (!ValidationUtil.isValidObject(dateStr)) {
            return null;
        }
        String formet = PatternUtil.dateMatch(dateStr.toString());
        if (formet == null) {
            return null;
        }
        SimpleDateFormat timeFormat = new SimpleDateFormat(formet);
        Date date = null;
        try {
            date = timeFormat.parse(dateStr.toString());
        }
        catch (ParseException e) {
            System.err.println("WARN: unexpected object in Object.dateValue(): " + dateStr);
        }
        return date;
    }

    public static Date sqlDateObject(Object dateStr) {
        if (!ValidationUtil.isValidObject(dateStr)) {
            return null;
        }
        String formet = PatternUtil.dateMatch(dateStr.toString());
        if (formet == null) {
            return null;
        }
        SimpleDateFormat timeFormat = new SimpleDateFormat(formet);
        Date date = null;
        try {
            date = timeFormat.parse(dateStr.toString());
        }
        catch (ParseException e) {
            System.err.println("WARN: unexpected object in Object.dateValue(): " + dateStr);
        }
        return new java.sql.Date(date.getTime());
    }

    public static Date sqlDateTimeObject(Object dateStr) {
        String formet = PatternUtil.dateTimeMatch(dateStr.toString());
        if (formet == null) {
            return null;
        }
        SimpleDateFormat timeFormat = new SimpleDateFormat(formet);
        Date date = null;
        try {
            date = timeFormat.parse(dateStr.toString());
        }
        catch (ParseException e) {
            System.err.println("WARN: unexpected object in Object.dateValue(): " + dateStr);
        }
        return new java.sql.Date(date.getTime());
    }

    public static Timestamp sqlTimestempObject(Object dateStr) {
        String formet = PatternUtil.dateTimeMatch(dateStr.toString());
        if (formet == null) {
            return null;
        }
        SimpleDateFormat timeFormat = new SimpleDateFormat(formet);
        Date date = null;
        try {
            date = timeFormat.parse(dateStr.toString());
        }
        catch (ParseException e) {
            System.err.println("WARN: unexpected object in Object.dateValue(): " + dateStr);
        }
        return new Timestamp(date.getTime());
    }

    public static Calendar calenderForDate(String date, String seperator, String format) {
        if (format.compareTo("mmddyy") == 0) {
            int month = Integer.parseInt(date.substring(0, date.indexOf(seperator)));
            int year = Integer.parseInt(date.substring(date.lastIndexOf(seperator) + 1, date.length()));
            int day = Integer.parseInt(date.substring(date.indexOf(seperator) + 1, date.lastIndexOf(seperator)));
            if (year < 100) {
                year += 2000;
            }
            return DateUtil.calenderForDate(year, month, day);
        }
        if (format.compareTo("ddmmyy") == 0) {
            int day = Integer.parseInt(date.substring(0, date.indexOf(seperator)));
            int year = Integer.parseInt(date.substring(date.lastIndexOf(seperator) + 1, date.length()));
            int month = Integer.parseInt(date.substring(date.indexOf(seperator) + 1, date.lastIndexOf(seperator)));
            if (year < 100) {
                year += 2000;
            }
            return DateUtil.calenderForDate(year, month, day);
        }
        if (format.compareTo("yymmdd") == 0) {
            int year = Integer.parseInt(date.substring(0, date.indexOf(seperator)));
            int day = Integer.parseInt(date.substring(date.lastIndexOf(seperator) + 1, date.length()));
            int month = Integer.parseInt(date.substring(date.indexOf(seperator) + 1, date.lastIndexOf(seperator)));
            if (year < 100) {
                year += 2000;
            }
            return DateUtil.calenderForDate(year, month, day);
        }
        if (format.compareTo("yyddmm") == 0) {
            int year = Integer.parseInt(date.substring(0, date.indexOf(seperator)));
            int month = Integer.parseInt(date.substring(date.lastIndexOf(seperator) + 1, date.length()));
            int day = Integer.parseInt(date.substring(date.indexOf(seperator) + 1, date.lastIndexOf(seperator)));
            if (year < 100) {
                year += 2000;
            }
            return DateUtil.calenderForDate(year, month, day);
        }
        System.err.println("WARN: unexpected object in Object.dateValue(): " + date);
        return null;
    }

    public static Calendar currentDate(int offSet) {
        Calendar date = Calendar.getInstance();
        date.set(date.get(1), date.get(2), date.get(5), 0, 0, 0);
        date.add(14, -1 * date.get(14));
        date.add(6, -1 * offSet);
        return date;
    }

    public static Calendar currentDate() {
        Calendar date = Calendar.getInstance();
        date.set(date.get(1), date.get(2), date.get(5), 0, 0, 0);
        date.add(14, -1 * date.get(14));
        date.add(6, 0);
        return date;
    }

    public static java.sql.Date currentSqlDate() {
        return new java.sql.Date(new Date().getTime());
    }

    public static Date currentUtilDate() {
        return new Date();
    }

    public static Calendar offsetDate(Calendar workingDate, int offSet) {
        Calendar date = Calendar.getInstance();
        date.set(workingDate.get(1), workingDate.get(2), workingDate.get(5), 0, 0, 0);
        date.add(14, -1 * workingDate.get(14));
        date.add(6, offSet);
        return date;
    }

    public static String dateString(Calendar calendar) {
        String YY = calendar.get(1) + "";
        String MM = calendar.get(2) + 1 + "";
        String DD = calendar.get(5) + "";
        if (MM.length() == 1) {
            MM = "0" + MM;
        }
        if (DD.length() == 1) {
            DD = "0" + DD;
        }
        return YY + "_" + MM + "_" + DD;
    }

    public static String dateString(Calendar calendar, String format, String seprater) {
        String YY = calendar.get(1) + "";
        String MM = calendar.get(2) + 1 + "";
        String DD = calendar.get(5) + "";
        String HH = calendar.get(10) + "";
        String MINS = calendar.get(12) + "";
        if (MM.length() == 1) {
            MM = "0" + MM;
        }
        if (DD.length() == 1) {
            DD = "0" + DD;
        }
        if (format.compareTo("mmddyy") == 0) {
            return MM + seprater + DD + seprater + YY;
        }
        if (format.compareTo("ddmmyy") == 0) {
            return DD + seprater + MM + seprater + YY;
        }
        if (format.compareTo("yymmdd") == 0) {
            return YY + seprater + MM + seprater + DD;
        }
        if (format.compareTo("yyddmm") == 0) {
            return YY + seprater + DD + seprater + MM;
        }
        if (format.compareTo("mmddyy HH:MM") == 0) {
            return MM + seprater + DD + seprater + YY + " " + HH + ":" + MINS;
        }
        if (format.compareTo("ddmmyy HH:MM") == 0) {
            return DD + seprater + MM + seprater + YY + " " + HH + ":" + MINS;
        }
        if (format.compareTo("yymmdd HH:MM") == 0) {
            return YY + seprater + MM + seprater + DD + " " + HH + ":" + MINS;
        }
        if (format.compareTo("yyddmm HH:MM") == 0) {
            return YY + seprater + DD + seprater + MM + " " + HH + ":" + MINS;
        }
        return MM + seprater + DD + seprater + YY;
    }

    public static String dateStringFormatted(Calendar date, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        String formatedDate = formatter.format(date.getTime());
        return formatedDate;
    }

    public static String dateStringFormatted(Date date, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        String formatedDate = formatter.format(date);
        return formatedDate;
    }

    public static String dateFileString(Calendar calendar) {
        String YY = calendar.get(1) + "";
        String MM = calendar.get(2) + 1 + "";
        String DD = calendar.get(5) + "";
        if (MM.length() == 1) {
            MM = "0" + MM;
        }
        if (DD.length() == 1) {
            DD = "0" + DD;
        }
        return MM + DD + YY.substring(2, 4);
    }

    public static String dateTimeString(Calendar calendar) {
        String YY = calendar.get(1) + "";
        String MM = calendar.get(2) + 1 + "";
        String DD = calendar.get(5) + "";
        String HH = calendar.get(10) + "";
        String MI = calendar.get(12) + "";
        String SC = calendar.get(13) + "";
        String MS = calendar.get(14) + "";
        int AMint = calendar.get(9);
        String AMStr = AMint == 0 ? "AM" : "PM";
        if (MM.length() == 1) {
            MM = "0" + MM;
        }
        if (DD.length() == 1) {
            DD = "0" + DD;
        }
        if (HH.length() == 1) {
            HH = "0" + HH;
        }
        if (MI.length() == 1) {
            MI = "0" + MI;
        }
        if (SC.length() == 1) {
            SC = "0" + SC;
        }
        if (MS.length() == 1) {
            MS = "00" + MS;
        }
        if (MS.length() == 2) {
            MS = "0" + MS;
        }
        if (MS.length() == 3) {
            MS = MS + "";
        }
        return YY + "_" + MM + "_" + DD + "_" + HH + "_" + MI + "_" + SC + "_" + MS + "_" + AMStr;
    }

    public static String dateStringSTD(Calendar calendar) {
        String YY = calendar.get(1) + "";
        String MM = calendar.get(2) + 1 + "";
        String DD = calendar.get(5) + "";
        if (MM.length() == 1) {
            MM = "0" + MM;
        }
        if (DD.length() == 1) {
            DD = "0" + DD;
        }
        return MM + "/" + DD + "/" + YY;
    }

    public static String dateStringSTD1(Calendar calendar) {
        String YY = calendar.get(1) + "";
        String MM = calendar.get(2) + 1 + "";
        String DD = calendar.get(5) + "";
        if (MM.length() == 1) {
            MM = "0" + MM;
        }
        if (DD.length() == 1) {
            DD = "0" + DD;
        }
        return YY.substring(2, 4) + MM + DD;
    }

    public static Calendar calenderForDate(String date) {
        int month = Integer.parseInt(date.substring(0, date.indexOf("/")));
        int year = Integer.parseInt(date.substring(date.lastIndexOf("/") + 1, date.length()));
        int day = Integer.parseInt(date.substring(date.indexOf("/") + 1, date.lastIndexOf("/")));
        if (year < 100) {
            year += 2000;
        }
        return DateUtil.calenderForDate(year, month, day);
    }

    public static Calendar calenderForDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, 0, 0, 0);
        cal.add(14, -1 * cal.get(14));
        return cal;
    }

    public static Calendar calenderForDate(int year, int month, int day, int min) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, 0, min, 0);
        cal.add(14, -1 * cal.get(14));
        return cal;
    }

    public static int differeceDays(Calendar first, Calendar second) {
        long diff = second.getTime().getTime() - first.getTime().getTime();
        int days = (int)(diff / 86400000L);
        return days;
    }

    public static long getTime(Object obj) {
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        if (obj instanceof java.sql.Date) {
            return ((java.sql.Date)obj).getTime();
        }
        if (obj instanceof Time) {
            return ((Time)obj).getTime();
        }
        if (obj instanceof Timestamp) {
            return ((Timestamp)obj).getTime();
        }
        return 0L;
    }

    public static String getyyyyMMMddDateString() {
        GregorianCalendar gc = new GregorianCalendar();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(gc.getTime());
    }

    public static String getStandard1DateString() {
        return DateUtil.getFormattedCurrentDateTime("EEEEE MMMMM yyyy HH:mm:ss.SSSZ");
    }

    public static String getFormattedCurrentDateTime(String pattern) {
        GregorianCalendar gc = new GregorianCalendar();
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(gc.getTime());
    }

    public static String getDateInAnotherFormat(String dateString, String inputPattern, String outputPattern) {
        SimpleDateFormat inputDateFormat = new SimpleDateFormat(inputPattern);
        inputDateFormat.setLenient(false);
        Date date = inputDateFormat.parse(dateString, new ParsePosition(0));
        SimpleDateFormat outputDateFormat = new SimpleDateFormat(outputPattern);
        return outputDateFormat.format(date);
    }

    public static String getDateInAnotherFormat(String dateString, SimpleDateFormat inputDateFormat, SimpleDateFormat outputDateFormat) {
        Date date = inputDateFormat.parse(dateString, new ParsePosition(0));
        return outputDateFormat.format(date);
    }

    public static Date getDateForPattern(String dateString, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setLenient(false);
        return dateFormat.parse(dateString, new ParsePosition(0));
    }

    public static GregorianCalendar getTodayBusiGC() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return gc;
    }

    public static Calendar getTodayBusiCal() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar getCalForDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Calendar getCalForDate(Date date, int noOfDaysAway) {
        Calendar cal = DateUtil.getCalForDate(date);
        cal.add(5, noOfDaysAway);
        return cal;
    }

    public static Calendar getBusiCalForDate(Date date) {
        Calendar cal = DateUtil.getCalForDate(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar getBusiCalForDate(Date date, int noOfDaysAway) {
        Calendar cal = DateUtil.getBusiCalForDate(date);
        cal.add(5, noOfDaysAway);
        return cal;
    }

    public static java.sql.Date getBusiDateForDate(Date date, int noOfDaysAway) {
        Calendar cal = DateUtil.getBusiCalForDate(date, noOfDaysAway);
        return DateUtil.getBusiSqlDateForCal(cal);
    }

    public static Timestamp getTimestampForCal(Calendar cal) {
        return new Timestamp(cal.getTimeInMillis());
    }

    public static java.sql.Date getBusiSqlDateForCal(Calendar cal) {
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static java.sql.Date getTodayBusiSqlDate() {
        return new java.sql.Date(DateUtil.getTodayBusiGC().getTime().getTime());
    }

    public static GregorianCalendar getFirstDayOfMonthGC() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(5, 1);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return gc;
    }

    public static java.sql.Date getFirstDayOfMonthSqlDate() {
        return new java.sql.Date(DateUtil.getFirstDayOfMonthGC().getTime().getTime());
    }

    public static GregorianCalendar getFirstDayOfYearGC() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(2, 0);
        gc.set(5, 1);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return gc;
    }

    public static java.sql.Date getFirstDayOfYearSqlDate() {
        return new java.sql.Date(DateUtil.getFirstDayOfYearGC().getTime().getTime());
    }

    public static GregorianCalendar getBusiGcXDaysAwayFromToday(int noOfDaysAway) {
        GregorianCalendar gc = DateUtil.getTodayBusiGC();
        gc.add(5, noOfDaysAway);
        return gc;
    }

    public static Calendar getBusiCalXDaysAwayFromToday(int noOfDaysAway) {
        Calendar cal = DateUtil.getTodayBusiCal();
        cal.add(5, noOfDaysAway);
        return cal;
    }

    public static java.sql.Date getBusiSqlDateXDaysAwayFromToday(int noOfDaysAway) {
        return new java.sql.Date(DateUtil.getBusiGcXDaysAwayFromToday(noOfDaysAway).getTime().getTime());
    }

    public GregorianCalendar getNextMidNightGC(GregorianCalendar gc) {
        GregorianCalendar tempGC = (GregorianCalendar)gc.clone();
        tempGC.add(5, 1);
        tempGC.set(11, 0);
        tempGC.set(12, 0);
        tempGC.set(13, 0);
        tempGC.set(14, 0);
        return tempGC;
    }

    public static Calendar getNextHour() {
        Calendar cal = Calendar.getInstance();
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(11, 1);
        return cal;
    }

    public static Calendar getNextMinute() {
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(12, 1);
        return cal;
    }

    public static Calendar getNextDay() {
        Calendar cal = Calendar.getInstance();
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(11, 0);
        cal.add(5, 1);
        return cal;
    }

    public static GregorianCalendar getGCForPattern(String dateString, String pattern) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(DateUtil.getDateForPattern(dateString, pattern));
        return gc;
    }

    public static String getDateStringForPattern(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static String getDateStringForPattern(GregorianCalendar gc, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(gc.getTime());
    }

    public static double getOverLap(GregorianCalendar startT1, GregorianCalendar endT1, GregorianCalendar startT2, GregorianCalendar endT2) {
        if (startT1.after(endT2) || endT1.before(startT2)) {
            return 0.0;
        }
        double overLap = 0.0;
        if ((startT1.before(startT2) || startT1.equals(startT2)) && (endT1.after(endT2) || endT1.equals(endT2))) {
            overLap = (double)(endT2.getTimeInMillis() - startT2.getTimeInMillis()) / 1000.0 / 3600.0;
        } else if (startT1.after(startT2) && (endT1.after(endT2) || endT1.equals(endT2) || startT1.equals(endT2))) {
            overLap = (double)(endT2.getTimeInMillis() - startT1.getTimeInMillis()) / 1000.0 / 3600.0;
        } else if (endT1.before(endT2) && (startT1.before(startT2) || startT1.equals(startT2) || endT1.equals(startT2))) {
            overLap = (double)(endT1.getTimeInMillis() - startT2.getTimeInMillis()) / 1000.0 / 3600.0;
        } else if ((startT1.after(startT2) || startT1.equals(startT2)) && (endT1.before(endT2) || endT1.equals(endT2))) {
            overLap = (double)(endT1.getTimeInMillis() - startT1.getTimeInMillis()) / 1000.0 / 3600.0;
        }
        return overLap;
    }

    public static long getOverLapInSeconds(Date startT1, Date endT1, Date startT2, Date endT2) {
        if (startT1.after(endT2) || endT1.before(startT2)) {
            return 0L;
        }
        long overLap = 0L;
        if ((startT1.before(startT2) || startT1.equals(startT2)) && (endT1.after(endT2) || endT1.equals(endT2))) {
            overLap = (endT2.getTime() - startT2.getTime()) / 1000L;
        } else if (startT1.after(startT2) && (endT1.after(endT2) || endT1.equals(endT2) || startT1.equals(endT2))) {
            overLap = (endT2.getTime() - startT1.getTime()) / 1000L;
        } else if (endT1.before(endT2) && (startT1.before(startT2) || startT1.equals(startT2) || endT1.equals(startT2))) {
            overLap = (endT1.getTime() - startT2.getTime()) / 1000L;
        } else if ((startT1.after(startT2) || startT1.equals(startT2)) && (endT1.before(endT2) || endT1.equals(endT2))) {
            overLap = (endT1.getTime() - startT1.getTime()) / 1000L;
        }
        return overLap;
    }

    public static boolean isOverlap(Date startT1, Date endT1, Date startT2, Date endT2) {
        return startT1.compareTo(endT2) <= 0 && endT1.compareTo(startT2) >= 0;
    }

    public static int getOverlapInDays(Date startT1, Date endT1, Date startT2, Date endT2) {
        if (startT1.compareTo(endT2) > 0 || endT1.compareTo(startT2) < 0) {
            return 0;
        }
        long overLap = 0L;
        if (startT1.compareTo(startT2) <= 0 && endT1.compareTo(endT2) >= 0) {
            overLap = (endT2.getTime() - startT2.getTime()) / 1000L / 3600L / 24L + 1L;
        } else if (startT1.compareTo(startT2) > 0 && (endT1.compareTo(endT2) >= 0 || startT1.compareTo(endT2) == 0)) {
            overLap = (endT2.getTime() - startT1.getTime()) / 1000L / 3600L / 24L + 1L;
        } else if (endT1.compareTo(endT2) < 0 && (startT1.compareTo(startT2) <= 0 || endT1.compareTo(startT2) == 0)) {
            overLap = (endT1.getTime() - startT2.getTime()) / 1000L / 3600L / 24L + 1L;
        } else if (startT1.compareTo(startT2) >= 0 && endT1.compareTo(endT2) <= 0) {
            overLap = (endT1.getTime() - startT1.getTime()) / 1000L / 3600L / 24L + 1L;
        }
        return (int)overLap;
    }

    public static long getOverLap(long startT1, long endT1, long startT2, long endT2) {
        if (startT1 > endT2 || endT1 < startT2) {
            return 0L;
        }
        long overLap = 0L;
        if (startT1 <= startT2 && endT1 >= endT2) {
            overLap = endT2 - startT2;
        } else if (startT1 > startT2 && (endT1 >= endT2 || startT1 == endT2)) {
            overLap = endT2 - startT1;
        } else if (endT1 < endT2 && (startT1 <= startT2 || endT1 == startT2)) {
            overLap = endT1 - startT2;
        } else if (startT1 >= startT2 && endT1 <= endT2) {
            overLap = endT1 - startT1;
        }
        return overLap;
    }

    public static long getOverLapInclEnds(long startT1, long endT1, long startT2, long endT2) {
        if (startT1 > endT2 || endT1 < startT2) {
            return 0L;
        }
        long overLap = 0L;
        if (startT1 <= startT2 && endT1 >= endT2) {
            overLap = endT2 - startT2 + 1L;
        } else if (startT1 > startT2 && (endT1 >= endT2 || startT1 == endT2)) {
            overLap = endT2 - startT1 + 1L;
        } else if (endT1 < endT2 && (startT1 <= startT2 || endT1 == startT2)) {
            overLap = endT1 - startT2 + 1L;
        } else if (startT1 >= startT2 && endT1 <= endT2) {
            overLap = endT1 - startT1 + 1L;
        }
        return overLap;
    }

    public static Vector getPeriodInPieces(GregorianCalendar startDate, GregorianCalendar endDate, int unitType, int noOfUnits) {
        Hashtable<String, Object> hash;
        if (startDate.after(endDate)) {
            throw new RuntimeException("endDate is before startDate");
        }
        Vector periodPieces = new Vector();
        GregorianCalendar gc = (GregorianCalendar)startDate.clone();
        while (true) {
            hash = new Hashtable<String, Object>();
            hash.put("startDate", gc.clone());
            periodPieces.addElement(hash);
            switch (unitType) {
                case 1: {
                    gc.add(5, noOfUnits);
                    break;
                }
                case 2: {
                    gc.add(2, noOfUnits);
                    break;
                }
                case 3: {
                    gc.add(1, noOfUnits);
                    break;
                }
                default: {
                    throw new RuntimeException("unitType could not be recognized");
                }
            }
            if (!gc.before(endDate)) break;
            GregorianCalendar endGC = (GregorianCalendar)gc.clone();
            endGC.add(13, -1);
            hash.put("endDate", endGC);
        }
        hash.put("endDate", endDate.clone());
        return periodPieces;
    }

    public static int getOverlap(int startT1, int endT1, int startT2, int endT2) {
        if (startT1 > endT2 || endT1 < startT2) {
            return 0;
        }
        if (startT1 <= startT2 && endT1 >= endT2) {
            return endT2 - startT2 + 1;
        }
        if (startT1 > startT2 && (endT1 >= endT2 || startT1 == endT2)) {
            return endT2 - startT1 + 1;
        }
        if (endT1 < endT2 && (startT1 <= startT2 || endT1 == startT2)) {
            return endT1 - startT2 + 1;
        }
        if (startT1 >= startT2 && endT1 <= endT2) {
            return endT1 - startT1 + 1;
        }
        return 0;
    }

    public static boolean isDateOverlap(Date startT1, Date endT1, Date startT2, Date endT2) {
        if (startT2.compareTo(startT1) >= 0 && startT2.compareTo(endT1) <= 0) {
            return true;
        }
        return endT2.compareTo(startT1) >= 0 && endT2.compareTo(endT1) <= 0;
    }
}

