/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.formatter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PatternUtil {
    public static String[] datetime = new String[]{"dd-MMM-yyyy h:mm a", "dd-MM-yyyy h:mm a", "yyyy-MM-dd HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "dd-MM-yyyy HH:mm:ss", "dd-M-yyyy hh:mm:ss", "dd/MMM/yyyy h:mm a", "dd/MM/yyyy h:mm a", "dd-MM-yyyy h:mm", "dd-MM-yyyy h:mm", "MM/dd/yyyy HH:mm z", "MM/dd/yyyy HH:mm", "yyyy/MM/dd HH:mm:ss.SSSZ", "yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss", "dd/MM/yyyy HH:mm:ss", "dd/MM/yyyy h:mm", "dd/MMM/yyyy h:mm", "EEEEE MMMMM yyyy HH:mm:ss.SSSZ", "MMM dd, yyyy HH:mm z"};
    public static String[] time = new String[]{"h:mm a", "hh:mm", "HH:mm"};
    public static String[] date = new String[]{"dd/MM/yy", "dd/MM/yyyy", "MM/dd/yyyy", "MM/dd/yyyy", "yyyy/MM/dd", "dd-MM-yy", "dd-MM-yyyy", "MM/dd/yyyy", "MM-dd-yyyy", "yyyy-MM-dd"};

    public static Map<String, String> patternMap() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        return mapping;
    }

    public static String patternMatch(String date) {
        Set<Map.Entry<String, String>> entries = PatternUtil.patternMap().entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String pattern = entry.getValue();
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            try {
                if (dateFormat.parseObject(date) == null) continue;
                return pattern;
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public static String dateMatch(String dateStr) {
        for (String pattern : date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            try {
                if (dateFormat.parseObject(dateStr) == null) continue;
                return pattern;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String timeMatch(String timeStr) {
        for (String pattern : time) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            try {
                if (dateFormat.parseObject(timeStr) == null) continue;
                System.err.println();
                return pattern;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String dateTimeMatch(String dateTimeStr) {
        for (String pattern : datetime) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            try {
                if (dateFormat.parseObject(dateTimeStr) == null) continue;
                return pattern;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean simpleMatch(String pattern, String str) {
        if (pattern == null || str == null) {
            return false;
        }
        int firstIndex = pattern.indexOf(42);
        if (firstIndex == -1) {
            return pattern.equals(str);
        }
        if (firstIndex == 0) {
            if (pattern.length() == 1) {
                return true;
            }
            int nextIndex = pattern.indexOf(42, firstIndex + 1);
            if (nextIndex == -1) {
                return str.endsWith(pattern.substring(1));
            }
            String part = pattern.substring(1, nextIndex);
            int partIndex = str.indexOf(part);
            while (partIndex != -1) {
                if (PatternUtil.simpleMatch(pattern.substring(nextIndex), str.substring(partIndex + part.length()))) {
                    return true;
                }
                partIndex = str.indexOf(part, partIndex + 1);
            }
            return false;
        }
        return str.length() >= firstIndex && pattern.substring(0, firstIndex).equals(str.substring(0, firstIndex)) && PatternUtil.simpleMatch(pattern.substring(firstIndex), str.substring(firstIndex));
    }

    public static boolean simpleMatch(String[] patterns, String str) {
        if (patterns != null) {
            for (int i = 0; i < patterns.length; ++i) {
                if (!PatternUtil.simpleMatch(patterns[i], str)) continue;
                return true;
            }
        }
        return false;
    }
}

