/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.resouces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.brijframework.util.validator.ValidationUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class JSONUtil {
    public static <T> boolean isJDKClass(T t) {
        return t.getClass().getPackage().getName().startsWith("java");
    }

    private static JSONObject getJSONObject(Object object) {
        Map map = (Map)object;
        return new JSONObject(map);
    }

    private static JSONArray getJSONArray(Object object) {
        JSONArray json = new JSONArray();
        for (Object value : (Iterable)object) {
            json.put((Object)JSONUtil.getJSONObject(value));
        }
        return json;
    }

    public static Object getJSONObjectFromObject(Object object) {
        JSONObject obj = null;
        if (object instanceof Map) {
            obj = JSONUtil.getJSONObject(object);
        } else if (object instanceof Iterable) {
            obj = JSONUtil.getJSONArray(object);
        }
        return obj;
    }

    public static HashMap<String, Object> getMapFromJSONObject(JSONObject object, String key) throws JSONException {
        return JSONUtil.getMapFromJSONObject(object.getJSONObject(key));
    }

    public static HashMap<String, Object> getMapFromJSONObject(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            map.put(key, JSONUtil.getObjectFromJSON(object.get(key)));
        }
        return map;
    }

    public static ArrayList<Object> getListFromJSONArray(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(JSONUtil.getObjectFromJSON(array.get(i)));
        }
        return list;
    }

    public static Object getObjectFromJSON(Object json) throws JSONException {
        if (json == JSONObject.NULL) {
            return null;
        }
        if (json instanceof JSONObject) {
            return JSONUtil.getMapFromJSONObject((JSONObject)json);
        }
        if (json instanceof JSONArray) {
            return JSONUtil.getListFromJSONArray((JSONArray)json);
        }
        return json;
    }

    public static JSONObject getJSONFromXML(String xml) {
        JSONObject jsonObj = null;
        try {
            jsonObj = XML.toJSONObject((String)xml);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public static String getXMLFromJSON(Object obj) {
        try {
            return XML.toString((Object)obj);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONObject getJSONObjectFromJSONString(String json) {
        try {
            return new JSONObject(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONArray getJSONArrayFromJSONString(String json) {
        try {
            return new JSONArray(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> getMapFromJSONString(String json) {
        return JSONUtil.getMap(JSONUtil.getJSONObjectFromJSONString(json));
    }

    public static Map<String, Object> getMap(JSONObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = null;
            try {
                value = jsonObject.get(key);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            map.put(key, value instanceof JSONObject ? JSONUtil.getMap((JSONObject)value) : (value instanceof JSONArray ? JSONUtil.getList((JSONArray)value) : value));
        }
        return map;
    }

    public static List<Object> getList(JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            try {
                if (array.get(i) instanceof JSONObject) {
                    list.add(JSONUtil.getMap(array.getJSONObject(i)));
                    continue;
                }
                list.add(array.get(i));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return list;
    }

    public static List<Object> getListFromJSONArray(String json) {
        if ((json = json.trim()).startsWith("[")) {
            JSONArray array = JSONUtil.getJSONArrayFromJSONString(json);
            return JSONUtil.getList(array);
        }
        return null;
    }

    public static String getJsonStringFromObject(Object cache) {
        StringBuilder builder = new StringBuilder();
        if (cache instanceof Map) {
            builder.append(JSONUtil.getJsonStringFromMap((Map)cache));
        }
        if (cache instanceof Collection) {
            builder.append(JSONUtil.getJsonStringFromCollection((Collection)cache));
        }
        if (ValidationUtil.isPrimative(cache).booleanValue()) {
            builder.append(cache);
        } else {
            System.out.println(cache);
        }
        return builder.toString();
    }

    public static String getJsonStringFromCollection(Collection<? extends Object> cache) {
        StringBuilder builder = new StringBuilder();
        AtomicInteger count = new AtomicInteger(0);
        builder.append("[");
        cache.forEach(object -> {
            builder.append(JSONUtil.getJsonStringFromObject(cache));
            if (count.incrementAndGet() < cache.size()) {
                builder.append(",");
            }
        });
        builder.append("]");
        return builder.toString();
    }

    public static String getJsonStringFromMap(Map<?, ?> cache) {
        StringBuilder builder = new StringBuilder();
        AtomicInteger count = new AtomicInteger(0);
        builder.append("{");
        cache.entrySet().forEach(node -> {
            builder.append(node.getKey() + ":" + node.getValue());
            if (count.incrementAndGet() < cache.size()) {
                builder.append(",");
            }
        });
        builder.append("}");
        return builder.toString();
    }

    public static Map<String, Object> toMap(String json) {
        JSONObject object = null;
        try {
            object = new JSONObject(json);
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
        HashMap<String, Object> source = new HashMap<String, Object>();
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            Object key = keys.next();
            try {
                Object value = object.get(key.toString());
                if (value instanceof JSONArray) {
                    source.put(key.toString(), JSONUtil.toList((JSONArray)value));
                    continue;
                }
                if (value instanceof JSONObject) {
                    source.put(key.toString(), JSONUtil.toMap((JSONObject)value));
                    continue;
                }
                source.put(key.toString(), value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return source;
    }

    public static List<Object> toList(JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            try {
                Object value = array.get(i);
                if (value instanceof JSONArray) {
                    list.add(JSONUtil.toList((JSONArray)value));
                    continue;
                }
                if (value instanceof JSONObject) {
                    list.add(JSONUtil.toMap((JSONObject)value));
                    continue;
                }
                list.add(value);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static Map<?, ?> toMap(JSONObject object) {
        HashMap map = new HashMap();
        object.keys().forEachRemaining(key -> {
            Object value = null;
            try {
                value = object.get(key.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (value instanceof JSONArray) {
                map.put(key.toString(), JSONUtil.toList((JSONArray)value));
            } else if (value instanceof JSONObject) {
                map.put(key.toString(), JSONUtil.toMap((JSONObject)value));
            } else {
                map.put(key.toString(), value);
            }
        });
        return map;
    }
}

