/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.resouces;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.brijframework.util.resouces.JSONUtil;
import org.brijframework.util.validator.ValidationUtil;
import org.json.JSONException;
import org.json.XML;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XMLUtil {
    public static byte[] documentToBytes(Document _doc) {
        return XMLUtil.documentToText(_doc).getBytes();
    }

    public static Document bytesToDocument(byte[] _bytes) {
        return XMLUtil.xmlTextToDocument(new String(_bytes));
    }

    public static Document xmlTextToDocument(String _string) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(_string)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String documentToText(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            return null;
        }
    }

    public static Map<String, Object> rootMapFromXML(String xmlString) {
        if (ValidationUtil.isEmptyObject(xmlString)) {
            return null;
        }
        try {
            return JSONUtil.getMapFromJSONObject(XML.toJSONObject((String)xmlString));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCleanXMLFor(String str) {
        if (str == null) {
            return "";
        }
        if (str.indexOf(38) == -1 && str.indexOf(60) == -1) {
            return str;
        }
        if (str.equals("&nbsp;")) {
            return str;
        }
        StringBuffer strBuf = new StringBuffer();
        char[] charArray = str.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == '&') {
                strBuf.append("&amp;");
                continue;
            }
            if (charArray[i] == '<') {
                strBuf.append("&lt;");
                continue;
            }
            if (charArray[i] == '>') {
                strBuf.append("&gt;");
                continue;
            }
            strBuf.append(charArray[i]);
        }
        return strBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getXmlDocFromString(String string) throws Exception {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        StringReader stringReader = null;
        try {
            stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            Document document = builder.parse(inputSource);
            return document;
        }
        finally {
            try {
                stringReader.close();
            }
            catch (Exception exception) {}
        }
    }
}

