/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.resouces;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.yaml.snakeyaml.Yaml;

public class YamlUtil {
    public static HashMap<String, Object> getHashMap(File file) {
        try {
            return YamlUtil.getHashMap(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Properties getEnvProperties(File file) {
        Properties envproperties = new Properties();
        HashMap<String, Object> properties = YamlUtil.getHashMap(file);
        YamlUtil.buildProps(envproperties, properties);
        return envproperties;
    }

    public static Properties getEnvProperties(String yml) {
        Properties envproperties = new Properties();
        HashMap<String, Object> properties = YamlUtil.getHashMap(yml);
        YamlUtil.buildProps(envproperties, properties);
        return envproperties;
    }

    private static void buildProps(Properties envproperties, Map<String, Object> properties) {
        properties.forEach((parentkey, value) -> {
            if (value instanceof Map) {
                YamlUtil.buildProps(parentkey, envproperties, (Map)value);
            } else if (value instanceof List) {
                YamlUtil.buildProps(parentkey, envproperties, (List)value);
            } else {
                envproperties.put(parentkey, value);
            }
        });
    }

    private static void buildProps(String parentkey, Properties envproperties, List<Object> array) {
        envproperties.put(parentkey, array);
        for (int index = 0; index < array.size(); ++index) {
            Object value = array.get(index);
            if (value instanceof Map) {
                YamlUtil.buildProps(parentkey + "[" + index + "]", envproperties, (Map)value);
                continue;
            }
            if (value instanceof List) {
                YamlUtil.buildProps(parentkey + "[" + index + "]", envproperties, (List)value);
                continue;
            }
            envproperties.put(parentkey + "[" + index + "]", value);
        }
    }

    private static void buildProps(String parentkey, Properties envproperties, Map<String, Object> properties) {
        envproperties.put(parentkey, properties);
        properties.forEach((key, value) -> {
            if (value instanceof Map) {
                YamlUtil.buildProps(parentkey + "." + key, envproperties, (Map)value);
            } else if (value instanceof List) {
                YamlUtil.buildProps(parentkey + "." + key, envproperties, (List)value);
            } else {
                envproperties.put(parentkey + "." + key, value);
            }
        });
    }

    public static Properties getProperties(File file) {
        try {
            return YamlUtil.getProperties(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Properties getProperties(InputStream in) {
        return (Properties)YamlUtil.getObjectMap(Properties.class, in);
    }

    public static HashMap<String, Object> getHashMap(InputStream in) {
        return (HashMap)YamlUtil.getObjectMap(HashMap.class, in);
    }

    public static HashMap<String, Object> getHashMap(String yml) {
        return (HashMap)YamlUtil.getObjectMap(HashMap.class, yml);
    }

    public static <T> T getObjectMap(Class<?> cls, String yml) {
        Yaml yaml = new Yaml();
        return (T)yaml.loadAs(yml, cls);
    }

    public static <T> T getObjectMap(Class<?> cls, InputStream in) {
        Yaml yaml = new Yaml();
        return (T)yaml.loadAs(in, cls);
    }
}

