/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;

public class SystemUtil {
    public static void systemInfo(String[] args) {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File[] drives = File.listRoots();
        if (drives != null && drives.length > 0) {
            for (File aDrive : drives) {
                System.out.println("Drive Letter: " + aDrive);
                System.out.println("\tType: " + fsv.getSystemTypeDescription(aDrive));
                System.out.println("\tTotal space: " + aDrive.getTotalSpace());
                System.out.println("\tFree space: " + aDrive.getFreeSpace());
                System.out.println();
            }
        }
    }

    public static Long totalSpace(File disk) {
        return disk.getTotalSpace();
    }

    public static Long usedSpace(File disk) {
        return SystemUtil.totalSpace(disk) - disk.getUsableSpace();
    }

    public static Long freeSpace(File disk) {
        return disk.getFreeSpace();
    }

    public static void printSystemMemStates() {
        Runtime runtime = Runtime.getRuntime();
        NumberFormat format = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        sb.append("Current Free memory: " + format.format(freeMemory / 1024L) + "\r\n");
        sb.append("Allocated memory: " + format.format(allocatedMemory / 1024L) + "\r\n");
        sb.append("Max memory: " + format.format(maxMemory / 1024L) + "\r\n");
        sb.append("Total free memory: " + format.format((freeMemory + (maxMemory - allocatedMemory)) / 1024L) + "\r\n");
        System.out.println(sb);
    }

    public static Map<String, Object> diskPaths() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterable<Path> iterable = FileSystems.getDefault().getRootDirectories();
        for (Path path : iterable) {
            HashMap<String, Comparable<Path>> fileMap = new HashMap<String, Comparable<Path>>();
            fileMap.put("AbsolutePath", path.toAbsolutePath());
            fileMap.put("Uri", path.toUri());
            fileMap.put("RootPath", path.getRoot());
            fileMap.put("NameCount", Integer.valueOf(path.getNameCount()));
            System.out.println(fileMap);
        }
        return map;
    }

    public static void diskStoreDefault() {
        Iterable<FileStore> iterable1 = FileSystems.getDefault().getFileStores();
        for (FileStore fileStore : iterable1) {
            try {
                HashMap<String, Object> fileStoreMap = new HashMap<String, Object>();
                fileStoreMap.put("TotalSpace", fileStore);
                fileStoreMap.put("TotalSpace", fileStore.getTotalSpace());
                fileStoreMap.put("Name", fileStore.name());
                fileStoreMap.put("UnallocatedSpace", fileStore.getUnallocatedSpace());
                fileStoreMap.put("UsableSpace", fileStore.getUsableSpace());
                fileStoreMap.put("isReadOnly", fileStore.isReadOnly());
                fileStoreMap.put("type", fileStore.type());
                System.out.println(fileStoreMap);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, Object> diskHistory(URI uri) {
        Iterable<FileStore> iterable = FileSystems.getFileSystem(uri).getFileStores();
        HashMap<String, Object> fileMap = new HashMap<String, Object>();
        for (FileStore fileStore : iterable) {
            try {
                HashMap<String, Object> fileStoreMap = new HashMap<String, Object>();
                fileStoreMap.put("TotalSpace", fileStore);
                fileStoreMap.put("TotalSpace", fileStore.getTotalSpace());
                fileStoreMap.put("Name", fileStore.name());
                fileStoreMap.put("UnallocatedSpace", fileStore.getUnallocatedSpace());
                fileStoreMap.put("UsableSpace", fileStore.getUsableSpace());
                fileStoreMap.put("isReadOnly", fileStore.isReadOnly());
                fileStoreMap.put("type", fileStore.type());
                fileMap.put(fileStore.name(), fileStoreMap);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileMap;
    }

    public static void main(String[] args) throws URISyntaxException {
        SystemUtil.diskPaths();
        FileSystems.getDefault().provider();
        System.out.println(FileSystemProvider.installedProviders().get(0));
    }
}

