/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class WatchUtil {
    public static void watchService(URI paths) {
        try {
            WatchKey key;
            boolean valid;
            WatchService watcher = FileSystems.getDefault().newWatchService();
            Path dir = Paths.get(paths);
            dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
            System.out.println("Watch Service registered for dir: " + dir.getFileName());
            do {
                try {
                    key = watcher.take();
                }
                catch (InterruptedException ex) {
                    return;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent<?> ev = event;
                    Path fileName = (Path)ev.context();
                    System.out.println(kind.name() + ": " + fileName);
                    if (kind != StandardWatchEventKinds.ENTRY_MODIFY || !fileName.toString().equals("FileWatchUtil.java")) continue;
                    System.out.println("My source file has changed!!!");
                }
            } while (valid = key.reset());
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    public static void watchFile(File file) throws IOException {
        WatchKey key;
        boolean valid;
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Path dir = Paths.get(file.getParent(), new String[0]);
        dir.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
        System.out.println("Watch Service registered for dir: " + dir.getFileName());
        do {
            try {
                key = watcher.take();
            }
            catch (InterruptedException ex) {
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                System.out.println("My source file has changed!!!");
            }
        } while (valid = key.reset());
    }
}

