/*
 * Decompiled with CFR 0.152.
 */
package api.log.aop;

import api.log.business.formater.ParamFormatter;
import api.log.business.outer.Outer;
import api.log.core.Cache;
import api.log.core.ContextUtil;
import api.log.core.OutContent;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class MethodAdvice
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        boolean hasMethod = Cache.hasMethod(invocation.getMethod());
        OutContent content = new OutContent();
        Object returnVal = null;
        if (!hasMethod) {
            returnVal = invocation.proceed();
            return returnVal;
        }
        try {
            ParamFormatter formatter = ContextUtil.getBean(ParamFormatter.class);
            Object format = formatter.format(invocation.getMethod().getParameters(), invocation.getArguments());
            content.setParam(format);
            long start = System.currentTimeMillis();
            returnVal = invocation.proceed();
            content.setResult(returnVal);
            long spend = System.currentTimeMillis() - start;
            content.setTime(spend);
        }
        catch (Exception e) {
            content.setException(e);
            throw e;
        }
        finally {
            Outer outer = ContextUtil.getBean(Outer.class);
            outer.out(invocation.getMethod(), content);
        }
        return returnVal;
    }
}

