/*
 * Decompiled with CFR 0.152.
 */
package api.log.business.outer;

import api.log.business.outer.Outer;
import api.log.business.socket.SessionContext;
import api.log.business.socket.SessionManager;
import api.log.business.socket.SocketHandler;
import api.log.core.Cache;
import api.log.core.ContextUtil;
import api.log.core.MonitorInfo;
import api.log.core.OutContent;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

public class WebSocketOuter
implements Outer {
    ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void out(Method method, OutContent outContent) {
        Map<String, MonitorInfo> monitorOfUser = Cache.getUsersByMethod(method);
        SocketHandler socketHandler = ContextUtil.getBean(SocketHandler.class);
        monitorOfUser.forEach((userId, monitorInfo) -> {
            try {
                SessionContext session = ContextUtil.getBean(SessionManager.class).getSession((String)userId);
                if (!session.getSession().isOpen()) {
                    return;
                }
                StringBuilder sb = new StringBuilder("@@");
                StringBuilder err = new StringBuilder();
                boolean sendNormal = false;
                boolean sendException = false;
                if (monitorInfo.isParam()) {
                    sendNormal = true;
                    sb.append("[PARAM] ");
                    this.appendValue(sb, this.objectMapper, outContent.getParam());
                    sb.append("@@");
                }
                if (monitorInfo.isResult()) {
                    sendNormal = true;
                    sb.append("[RESULT] ");
                    this.appendValue(sb, this.objectMapper, outContent.getResult());
                    sb.append("@@");
                }
                if (monitorInfo.isTime()) {
                    sendNormal = true;
                    sb.append("[TIME] ");
                    this.appendValue(sb, this.objectMapper, outContent.getTime());
                    sb.append("@@");
                }
                if (monitorInfo.isException() && outContent.getException() != null) {
                    sendException = true;
                    err.append("[ERROR] ");
                    this.appendException(err, outContent.getException());
                }
                if (sendNormal) {
                    socketHandler.sendToClient(session.getSession(), sb.toString().replaceAll("@@", "\n"));
                }
                if (sendException) {
                    socketHandler.sendToClient(session.getSession(), err.toString().replaceAll("@@", "\n"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void appendValue(StringBuilder sb, ObjectMapper mapper, Object value) throws JsonProcessingException {
        if (value == null) {
            sb.append("null");
            return;
        }
        if (value.getClass().isPrimitive() || value instanceof Number || value instanceof Boolean || value instanceof Character || value instanceof String) {
            sb.append(value);
        } else if (value.getClass().isArray()) {
            sb.append(Arrays.toString((Object[])value));
        } else {
            sb.append(mapper.writeValueAsString(value));
        }
    }

    public void appendException(StringBuilder sb, Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        sb.append(sw);
    }
}

