/*
 * Decompiled with CFR 0.152.
 */
package api.log.business.socket;

import api.log.business.cmd.ClearAll;
import api.log.business.cmd.Ls;
import api.log.business.cmd.LsMonitor;
import api.log.business.cmd.Monitor;
import api.log.business.cmd.Remove;
import api.log.business.socket.SessionContext;
import api.log.business.socket.SessionManager;
import java.io.IOException;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component(value="alogSocketHandler")
public class SocketHandler
extends TextWebSocketHandler {
    @Qualifier(value="alogSessionManager")
    @Autowired
    private SessionManager sessionManager;

    public void afterConnectionEstablished(WebSocketSession session) {
        SessionContext context = new SessionContext(session);
        this.sessionManager.addSession(session.getId(), context);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        this.sessionManager.removeSession(session.getId());
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        String cmd = (String)message.getPayload();
        try {
            this.executeCommand(cmd, this.sessionManager.getSession(session.getId()));
        }
        catch (Exception e) {
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)("Error: " + e.getMessage() + "\n")));
        }
    }

    private void executeCommand(String cmd, SessionContext context) throws IOException {
        WebSocketSession session = context.getSession();
        String userId = context.getUserId();
        if (Objects.isNull(cmd) || cmd.isEmpty()) {
            this.sendToClient(session, "[ERROR] \u8bf7\u8f93\u5165\u547d\u4ee4");
        } else {
            String[] parts = cmd.split("\\s+");
            String trimCmd = parts[0];
            Object result = "";
            if (trimCmd.equals("lsm")) {
                LsMonitor lsm = new LsMonitor(cmd);
                result = lsm.exec(userId);
                this.sendToClient(session, this.format(result.toString()));
            } else if (trimCmd.equals("ls")) {
                Ls ls = new Ls(cmd);
                result = ls.exec(userId);
                this.sendToClient(session, this.format(result.toString()));
            } else if (trimCmd.equals("monitor")) {
                result = new Monitor(cmd).exec(userId);
                this.sendToClient(session, result.toString());
            } else if (trimCmd.equals("remove")) {
                result = new Remove(cmd).exec(userId);
                this.sendToClient(session, result.toString());
            } else if (trimCmd.equals("clearall")) {
                result = new ClearAll(cmd).exec(userId);
                this.sendToClient(session, result.toString());
            } else {
                result = "[ERROR] \u547d\u4ee4\u4e0d\u652f\u6301";
                this.sendToClient(session, result.toString());
            }
        }
    }

    public void sendToClient(WebSocketSession session, String message) {
        try {
            if (session.isOpen()) {
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)(message + "\n")));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String format(String out) {
        return out.replace("@@", "\n");
    }
}

