/*
 * Decompiled with CFR 0.152.
 */
package api.log.core;

import api.log.core.Cache;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class ApiScanner
implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.scan();
    }

    private void scan() {
        Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
        handlerMethods.forEach((info, handlerMethod) -> {
            Set urlPatterns = info.getPatternsCondition().getPatterns();
            Method method = handlerMethod.getMethod();
            urlPatterns.forEach(url -> {
                if (!url.startsWith("/")) {
                    url = "/" + url;
                }
                Cache.methodCache.put((String)url, method);
            });
        });
    }
}

