/*
 * Decompiled with CFR 0.152.
 */
package api.log.core;

import api.log.core.MonitorInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Cache {
    public static volatile Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>(256);
    public static volatile Map<Method, List<String>> methodUsers;
    public static volatile Map<String, List<MonitorInfo>> userMethods;

    public static Method getMethod(String uri) {
        return methodCache.get(uri);
    }

    public static void addUser(Method method, String user) {
        List<Object> methods;
        if (!methodUsers.containsKey(method)) {
            ArrayList<String> users = new ArrayList<String>();
            users.add(user);
            methodUsers.put(method, users);
        } else {
            methodUsers.get(method).add(user);
        }
        if (!userMethods.containsKey(user)) {
            methods = new ArrayList();
            MonitorInfo monitorInfo = new MonitorInfo(method, true, false, false, false);
            monitorInfo.setMethod(method);
            methods.add(monitorInfo);
            userMethods.put(user, methods);
        } else {
            methods = userMethods.get(user);
            MonitorInfo monitorInfo = new MonitorInfo();
            monitorInfo.setMethod(method);
            methods.add(monitorInfo);
        }
    }

    public static void removeUser(Method method, String user) {
        if (methodUsers.containsKey(method)) {
            List<String> users = methodUsers.get(method);
            users.remove(user);
            if (users.isEmpty()) {
                methodUsers.remove(method);
            }
        }
    }

    public static boolean containsUser(Method method, String user) {
        if (methodUsers.containsKey(method)) {
            return methodUsers.get(method).contains(user);
        }
        return false;
    }

    public static boolean hasUser(String user) {
        return userMethods.containsKey(user);
    }

    public static void clearUser(String user) {
        if (userMethods.containsKey(user)) {
            userMethods.remove(user);
            methodUsers.forEach((k, v) -> v.remove(user));
        }
    }

    public static void addMethod(String user, MonitorInfo monitor) {
        if (!userMethods.containsKey(user)) {
            ArrayList<MonitorInfo> methods = new ArrayList<MonitorInfo>();
            methods.add(monitor);
            userMethods.put(user, methods);
        } else {
            userMethods.get(user).add(monitor);
        }
        if (methodUsers.containsKey(monitor.getMethod())) {
            methodUsers.get(monitor.getMethod()).add(user);
        } else {
            ArrayList<String> users = new ArrayList<String>();
            users.add(user);
            methodUsers.put(monitor.getMethod(), users);
        }
    }

    public static void removeMethod(String user, Method method) {
        if (userMethods.containsKey(user)) {
            List<MonitorInfo> monitors = userMethods.get(user);
            monitors.removeIf(m -> m.getMethod().equals(method));
            if (monitors.isEmpty()) {
                userMethods.remove(user);
            }
        }
    }

    public static boolean containsMethod(String user, Method method) {
        if (userMethods.containsKey(user)) {
            return userMethods.get(user).contains(method);
        }
        return false;
    }

    public static boolean hasMethod(Method method) {
        return methodUsers.containsKey(method);
    }

    public static boolean clearMethod(Method method) {
        if (methodUsers.containsKey(method)) {
            methodUsers.remove(method);
            return true;
        }
        return false;
    }

    public static boolean hasUri(String uri) {
        return methodCache.containsKey(uri);
    }

    public static Map<String, MonitorInfo> getUsersByMethod(Method method) {
        if (!methodUsers.containsKey(method)) {
            return Collections.emptyMap();
        }
        HashMap<String, MonitorInfo> result = new HashMap<String, MonitorInfo>();
        List<String> users = methodUsers.get(method);
        users.forEach(user -> {
            List<MonitorInfo> monitors = userMethods.get(user);
            if (Objects.isNull(monitors)) {
                return;
            }
            monitors.forEach(monitor -> {
                if (monitor.getMethod().equals(method)) {
                    result.put((String)user, (MonitorInfo)monitor);
                }
            });
        });
        return result;
    }

    public static List<String> getUrisByUser(String user) {
        ArrayList<String> uris = new ArrayList<String>();
        if (!userMethods.containsKey(user)) {
            return Collections.emptyList();
        }
        List methods = userMethods.get(user).stream().map(MonitorInfo::getMethod).collect(Collectors.toList());
        methodCache.forEach((uri, method) -> {
            if (methods.contains(method)) {
                uris.add((String)uri);
            }
        });
        return uris;
    }

    static {
        userMethods = new ConcurrentHashMap<String, List<MonitorInfo>>(1);
        methodUsers = new ConcurrentHashMap<Method, List<String>>(1);
    }
}

