/*
 * Decompiled with CFR 0.152.
 */
package api.log.core.config;

import api.log.aop.MethodAdvice;
import api.log.aop.MethodPointcut;
import api.log.business.formater.DefaultParamFormatter;
import api.log.business.outer.WebSocketOuter;
import api.log.business.socket.SocketHandler;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@EnableWebSocket
@Configuration
@EnableAspectJAutoProxy
public class ALogAutoConfiguration
implements ImportBeanDefinitionRegistrar,
WebSocketConfigurer {
    @Qualifier(value="alogSocketHandler")
    @Autowired
    private SocketHandler socketHandler;

    @Bean
    public MethodPointcut pointcut() {
        return new MethodPointcut();
    }

    @Bean
    public MethodAdvice advice() {
        return new MethodAdvice();
    }

    @Bean
    public DefaultPointcutAdvisor defaultPointcutAdvisor() {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor((Pointcut)this.pointcut(), (Advice)this.advice());
        advisor.setOrder(Integer.MAX_VALUE);
        return advisor;
    }

    @Order(value=0)
    @Bean
    public WebMvcConfigurer alogTerminalWebMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                registry.addResourceHandler(new String[]{"/alog/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/alog/"}).resourceChain(true);
            }
        };
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.registerBean(registry);
        this.scanPackages(registry, "api.log");
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry.addHandler((WebSocketHandler)this.socketHandler, new String[]{"/alog-ws"}).setAllowedOrigins(new String[]{"*"});
    }

    private void registerBean(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder defaultParamFormatterBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultParamFormatter.class).setScope("singleton");
        if (!registry.containsBeanDefinition("defaultParamFormatter")) {
            registry.registerBeanDefinition("defaultParamFormatter", (BeanDefinition)defaultParamFormatterBuilder.getBeanDefinition());
        }
        BeanDefinitionBuilder defaultOuterBuilder = BeanDefinitionBuilder.rootBeanDefinition(WebSocketOuter.class).setScope("singleton");
        if (!registry.containsBeanDefinition("webSocketOuter")) {
            registry.registerBeanDefinition("webSocketOuter", (BeanDefinition)defaultOuterBuilder.getBeanDefinition());
        }
    }

    private void scanPackages(BeanDefinitionRegistry registry, String ... basePackages) {
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(registry);
        scanner.scan(basePackages);
    }
}

