/*
 * Decompiled with CFR 0.152.
 */
package api.log.web;

import api.log.core.Constant;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;

@Controller
public class AlogWeb {
    @GetMapping(value={"/alog/alog-terminal.html"})
    public ResponseEntity<byte[]> alogTerminal(HttpServletRequest request, @RequestHeader(value="Accept-Language", required=false) String acceptLanguage) throws IOException {
        ClassPathResource resource = new ClassPathResource("META-INF/resources/alog/alog-terminal.html");
        if (!resource.exists()) {
            return ResponseEntity.notFound().build();
        }
        String language = this.determineLanguage(acceptLanguage);
        Map<String, String> i18nMap = this.loadI18nResources(language);
        String htmlContent = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        htmlContent = this.processPlaceholder(htmlContent, i18nMap);
        return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)htmlContent.getBytes(StandardCharsets.UTF_8));
    }

    private String determineLanguage(String acceptLanguage) {
        String[] languages;
        if (acceptLanguage == null || acceptLanguage.isEmpty()) {
            return "en";
        }
        for (String lang : languages = acceptLanguage.split(",")) {
            String[] parts = lang.split(";");
            String language = parts[0].trim().toLowerCase();
            if (language.startsWith("zh")) {
                return "zh";
            }
            if (!language.startsWith("en")) continue;
            return "en";
        }
        return "en";
    }

    private Map<String, String> loadI18nResources(String language) throws IOException {
        String i18nFilePath = String.format("locales/%s.json", language);
        ClassPathResource i18nResource = new ClassPathResource("META-INF/resources/alog/" + i18nFilePath);
        if (!i18nResource.exists()) {
            i18nResource = new ClassPathResource("META-INF/resources/alog/locales/en.json");
        }
        String jsonContent = StreamUtils.copyToString((InputStream)i18nResource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        return this.json2Map(jsonContent);
    }

    private Map<String, String> json2Map(String json) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        json = json.replaceAll("[{}\"]", "").trim();
        for (String pair : pairs = json.split(",")) {
            String[] keyValue = pair.split(":", 2);
            if (keyValue.length != 2) continue;
            map.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return map;
    }

    private String processPlaceholder(String html, Map<String, String> i18nMap) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = Constant.I18N_PATTERN.matcher(html);
        while (matcher.find()) {
            String key = matcher.group(1);
            String replacement = i18nMap.getOrDefault(key, key);
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

