/*
 * Decompiled with CFR 0.152.
 */
package io.armadaproject;

import api.EventGrpc;
import api.EventOuterClass;
import api.Health;
import api.Job;
import api.JobsGrpc;
import api.SubmitGrpc;
import api.SubmitOuterClass;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;

public class ArmadaClient
implements AutoCloseable {
    private final ManagedChannel channel;

    public ArmadaClient(String host, int port) {
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
    }

    public ArmadaClient(String host, int port, String bearerToken) {
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).useTransportSecurity().intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)this.createAuthMetadata(bearerToken))}).build();
    }

    private Metadata createAuthMetadata(String token) {
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)("Bearer " + token));
        return metadata;
    }

    public Health.HealthCheckResponse.ServingStatus checkHealth() {
        SubmitGrpc.SubmitBlockingStub submitBlockingStub = SubmitGrpc.newBlockingStub((Channel)this.channel);
        Health.HealthCheckResponse healthCheckResponse = submitBlockingStub.health(Empty.getDefaultInstance());
        return healthCheckResponse.getStatus();
    }

    public SubmitOuterClass.JobSubmitResponse submitJob(SubmitOuterClass.JobSubmitRequest jobSubmitRequest) {
        SubmitGrpc.SubmitBlockingStub submitBlockingStub = SubmitGrpc.newBlockingStub((Channel)this.channel);
        return submitBlockingStub.submitJobs(jobSubmitRequest);
    }

    public SubmitOuterClass.CancellationResult cancelJob(SubmitOuterClass.JobCancelRequest jobCancelRequest) {
        SubmitGrpc.SubmitBlockingStub submitBlockingStub = SubmitGrpc.newBlockingStub((Channel)this.channel);
        return submitBlockingStub.cancelJobs(jobCancelRequest);
    }

    public Iterator<EventOuterClass.EventStreamMessage> getEvents(EventOuterClass.JobSetRequest jobSetRequest) {
        EventGrpc.EventBlockingStub eventBlockingStub = EventGrpc.newBlockingStub((Channel)this.channel);
        return eventBlockingStub.getJobSetEvents(jobSetRequest);
    }

    public void streamEvents(EventOuterClass.JobSetRequest jobSetRequest, StreamObserver<EventOuterClass.EventStreamMessage> streamObserver) {
        EventGrpc.EventStub eventStub = EventGrpc.newStub((Channel)this.channel);
        eventStub.getJobSetEvents(jobSetRequest, streamObserver);
    }

    public SubmitOuterClass.Queue getQueue(SubmitOuterClass.QueueGetRequest queueGetRequest) {
        SubmitGrpc.SubmitBlockingStub submitBlockingStub = SubmitGrpc.newBlockingStub((Channel)this.channel);
        return submitBlockingStub.getQueue(queueGetRequest);
    }

    public Iterator<SubmitOuterClass.StreamingQueueMessage> getQueueInfo(SubmitOuterClass.StreamingQueueGetRequest streamingQueueGetRequest) {
        SubmitGrpc.SubmitBlockingStub submitBlockingStub = SubmitGrpc.newBlockingStub((Channel)this.channel);
        return submitBlockingStub.getQueues(streamingQueueGetRequest);
    }

    public Job.JobStatusResponse getJobStatus(Job.JobStatusRequest jobStatusRequest) {
        JobsGrpc.JobsBlockingStub jobsBlockingStub = JobsGrpc.newBlockingStub((Channel)this.channel);
        return jobsBlockingStub.getJobStatus(jobStatusRequest);
    }

    @Override
    public void close() {
        this.channel.shutdown();
    }
}

