/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.directives;

import graphql.annotations.annotationTypes.GraphQLDirectives;
import graphql.annotations.directives.AnnotationsDirectiveWiring;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.schema.GraphQLDirective;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.stream.Stream;

public class DirectiveWiringMapRetriever {
    public HashMap<GraphQLDirective, AnnotationsDirectiveWiring> getDirectiveWiringMap(AnnotatedElement object, ProcessingElementsContainer container) {
        GraphQLDirectives directivesContainer = object.getAnnotation(GraphQLDirectives.class);
        LinkedHashMap<GraphQLDirective, AnnotationsDirectiveWiring> map = new LinkedHashMap<GraphQLDirective, AnnotationsDirectiveWiring>();
        if (directivesContainer == null) {
            return map;
        }
        ((Stream)Arrays.stream(directivesContainer.value()).sequential()).forEach(x -> {
            if (!container.getDirectiveRegistry().containsKey(x.name())) {
                throw new GraphQLAnnotationsException(String.format("No directive named %s is found in the directive registry", x.name()), null);
            }
            try {
                map.put(container.getDirectiveRegistry().get(x.name()), x.wiringClass().newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new GraphQLAnnotationsException("Cannot create an instance of the wiring class " + x.wiringClass().getSimpleName(), e);
            }
        });
        return map;
    }
}

