/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.strategies;

import graphql.ExecutionResult;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldValueInfo;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.VariableReference;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class EnhancedExecutionStrategy
extends AsyncSerialExecutionStrategy {
    private static final String CLIENT_MUTATION_ID = "clientMutationId";

    protected CompletableFuture<ExecutionResult> resolveField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, (Field)parameters.getField().get(0));
        if (fieldDef == null) {
            return null;
        }
        if (fieldDef.getName().contentEquals(CLIENT_MUTATION_ID)) {
            Object clientMutationId;
            Field field = (Field)executionContext.getOperationDefinition().getSelectionSet().getSelections().get(0);
            Argument argument = (Argument)field.getArguments().get(0);
            if (argument.getValue() instanceof VariableReference) {
                VariableReference ref = (VariableReference)argument.getValue();
                HashMap mutationInputVariables = (HashMap)executionContext.getVariables().get(ref.getName());
                clientMutationId = mutationInputVariables.get(CLIENT_MUTATION_ID);
            } else {
                ObjectValue value = (ObjectValue)((Argument)field.getArguments().get(0)).getValue();
                StringValue clientMutationIdVal = (StringValue)value.getObjectFields().stream().filter(f -> f.getName().contentEquals(CLIENT_MUTATION_ID)).findFirst().get().getValue();
                clientMutationId = clientMutationIdVal.getValue();
            }
            ExecutionStepInfo fieldTypeInfo = ExecutionStepInfo.newExecutionStepInfo().type((GraphQLType)fieldDef.getType()).parentInfo(parameters.getExecutionStepInfo()).build();
            ExecutionStrategyParameters newParameters = ExecutionStrategyParameters.newParameters().arguments(parameters.getArguments()).fields(parameters.getFields()).nonNullFieldValidator(parameters.getNonNullFieldValidator()).executionStepInfo(fieldTypeInfo).source(clientMutationId).build();
            return this.completeValue(executionContext, newParameters).getFieldValue();
        }
        return super.resolveField(executionContext, parameters);
    }

    protected FieldValueInfo completeValue(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        GraphQLType fieldType = parameters.getExecutionStepInfo().getType();
        Object result = parameters.getSource();
        if (result instanceof Enum && fieldType instanceof GraphQLEnumType) {
            Object value = ((GraphQLEnumType)fieldType).getCoercing().parseValue((Object)((Enum)result).name());
            return super.completeValue(executionContext, this.withSource(parameters, value));
        }
        if (result instanceof Optional) {
            Object value = ((Optional)result).orElse(null);
            return this.completeValue(executionContext, this.withSource(parameters, value));
        }
        return super.completeValue(executionContext, parameters);
    }

    private ExecutionStrategyParameters withSource(ExecutionStrategyParameters parameters, Object source) {
        return ExecutionStrategyParameters.newParameters().arguments(parameters.getArguments()).fields(parameters.getFields()).nonNullFieldValidator(parameters.getNonNullFieldValidator()).executionStepInfo(parameters.getExecutionStepInfo()).source(source).build();
    }
}

