/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.exchange;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.hyperliquid.sdk.api.API;
import io.github.hyperliquid.sdk.info.Info;
import io.github.hyperliquid.sdk.model.order.OrderRequest;
import io.github.hyperliquid.sdk.model.order.OrderWire;
import io.github.hyperliquid.sdk.utils.Signing;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.web3j.crypto.Credentials;

public class Exchange
extends API {
    private final Credentials wallet;
    private final Info info;

    public Exchange(String baseUrl, int timeout, Credentials wallet, Info info) {
        super(baseUrl, timeout);
        this.wallet = wallet;
        this.info = info;
    }

    public JsonNode order(OrderRequest req) {
        int assetId = this.info.nameToAsset(req.getCoin());
        OrderWire wire = Signing.orderRequestToOrderWire(assetId, req);
        Map<String, Object> action = Signing.orderWiresToOrderAction(List.of(wire));
        return this.postAction(action, null, null);
    }

    public JsonNode bulkOrders(List<OrderRequest> requests) {
        ArrayList<OrderWire> wires = new ArrayList<OrderWire>();
        for (OrderRequest r : requests) {
            int assetId = this.info.nameToAsset(r.getCoin());
            wires.add(Signing.orderRequestToOrderWire(assetId, r));
        }
        Map<String, Object> action = Signing.orderWiresToOrderAction(wires);
        return this.postAction(action, null, null);
    }

    public JsonNode cancel(String coinName, int oid) {
        int assetId = this.info.nameToAsset(coinName);
        LinkedHashMap<String, Integer> cancel = new LinkedHashMap<String, Integer>();
        cancel.put("coin", assetId);
        cancel.put("oid", oid);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "cancel");
        action.put("cancels", List.of(cancel));
        return this.postAction(action, null, null);
    }

    public JsonNode cancelByCloid(String coinName, String cloid) {
        int assetId = this.info.nameToAsset(coinName);
        LinkedHashMap<String, Object> cancel = new LinkedHashMap<String, Object>();
        cancel.put("coin", assetId);
        cancel.put("cloid", cloid);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "cancelByCloid");
        action.put("cancels", List.of(cancel));
        return this.postAction(action, null, null);
    }

    public JsonNode modifyOrder(String coinName, int oid, OrderRequest newReq) {
        int assetId = this.info.nameToAsset(coinName);
        OrderWire wire = Signing.orderRequestToOrderWire(assetId, newReq);
        LinkedHashMap<String, Object> modify = new LinkedHashMap<String, Object>();
        modify.put("coin", assetId);
        modify.put("oid", oid);
        modify.put("order", wire);
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "modifyOrder");
        action.put("modifies", List.of(modify));
        return this.postAction(action, null, null);
    }

    public JsonNode postAction(Map<String, Object> action, String vaultAddress, Long expiresAfter) {
        long nonce = Signing.getTimestampMs();
        byte[] hash = Signing.actionHash(action, nonce, vaultAddress, expiresAfter);
        LinkedHashMap<String, Object> domain = new LinkedHashMap<String, Object>();
        domain.put("name", "Exchange");
        domain.put("version", "1");
        LinkedHashMap<String, Object> types = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, List<Map<String, String>>> eip712Domain = new LinkedHashMap<String, List<Map<String, String>>>();
        eip712Domain.put("name", List.of(Map.of("name", "name", "type", "string")));
        eip712Domain.put("version", List.of(Map.of("name", "version", "type", "string")));
        types.put("EIP712Domain", eip712Domain);
        LinkedHashMap<String, Object> message = new LinkedHashMap<String, Object>();
        message.put("primaryType", "Action");
        message.put("actionHash", Base64.getEncoder().encodeToString(hash));
        Map<String, String> sig = Signing.signTypedData(this.wallet, domain, types, message);
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("action", action);
        payload.put("nonce", nonce);
        payload.put("signature", sig);
        if (vaultAddress != null) {
            payload.put("vaultAddress", vaultAddress);
        }
        if (expiresAfter != null) {
            payload.put("expiresAfter", expiresAfter);
        }
        payload.put("signatureChainId", 1);
        return this.post("/exchange", payload);
    }
}

