/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.model.info;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenOrder {
    private String coin;
    private String limitPx;
    private Long oid;
    private String side;
    private String sz;
    private Long timestamp;
    private Map<String, Object> extensions = new HashMap<String, Object>();

    @JsonAnySetter
    public void put(String key, Object value) {
        this.extensions.put(key, value);
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.extensions;
    }

    public String getCoin() {
        return this.coin;
    }

    public void setCoin(String coin) {
        this.coin = coin;
    }

    public String getLimitPx() {
        return this.limitPx;
    }

    public void setLimitPx(String limitPx) {
        this.limitPx = limitPx;
    }

    public Long getOid() {
        return this.oid;
    }

    public void setOid(Long oid) {
        this.oid = oid;
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public String getSz() {
        return this.sz;
    }

    public void setSz(String sz) {
        this.sz = sz;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public static class Builder {
        private final OpenOrder o = new OpenOrder();

        public Builder coin(String v) {
            this.o.coin = v;
            return this;
        }

        public Builder limitPx(String v) {
            this.o.limitPx = v;
            return this;
        }

        public Builder oid(Long v) {
            this.o.oid = v;
            return this;
        }

        public Builder side(String v) {
            this.o.side = v;
            return this;
        }

        public Builder sz(String v) {
            this.o.sz = v;
            return this;
        }

        public Builder timestamp(Long v) {
            this.o.timestamp = v;
            return this;
        }

        public Builder putExtra(String k, Object v) {
            this.o.extensions.put(k, v);
            return this;
        }

        public OpenOrder build() {
            return this.o;
        }
    }
}

