/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.github.hyperliquid.sdk.utils.Error;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class API {
    protected final String baseUrl;
    protected final OkHttpClient client;
    protected final ObjectMapper mapper;
    private static final ObjectMapper SHARED_MAPPER = API.createSharedMapper();

    private static ObjectMapper createSharedMapper() {
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        om.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return om;
    }

    public static ObjectMapper getSharedMapper() {
        return SHARED_MAPPER;
    }

    public static synchronized void registerModule(Module module) {
        if (module != null) {
            SHARED_MAPPER.registerModule(module);
        }
    }

    public API(String baseUrl, int timeout) {
        this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl");
        this.mapper = SHARED_MAPPER;
        this.client = new OkHttpClient.Builder().callTimeout(Duration.ofSeconds(timeout)).connectTimeout(Duration.ofSeconds(timeout)).readTimeout(Duration.ofSeconds(timeout)).writeTimeout(Duration.ofSeconds(timeout)).build();
    }

    public JsonNode post(String path, Object payload) {
        JsonNode jsonNode;
        block10: {
            String url = this.baseUrl + path;
            String json = this.mapper.writeValueAsString(payload);
            RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.parse((String)"application/json"));
            Request request = new Request.Builder().url(url).addHeader("Accept", "application/json").post(body).build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    String err;
                    int code = response.code();
                    String string = err = response.body() != null ? response.body().string() : "";
                    if (code >= 400 && code < 500) {
                        throw new Error.ClientError(code, err);
                    }
                    throw new Error.ServerError(code, err);
                }
                String resp = response.body() != null ? response.body().string() : "{}";
                jsonNode = this.mapper.readTree(resp);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new Error("Network or I/O error: " + e.getMessage());
                }
            }
            response.close();
        }
        return jsonNode;
    }
}

