/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.response.impl;

import io.github.ibuildthecloud.gdapi.context.ApiContext;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.response.HtmlTemplate;
import io.github.ibuildthecloud.gdapi.util.Settings;
import io.github.ibuildthecloud.gdapi.util.SettingsUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.servlet.http.Cookie;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultHtmlTemplate
implements HtmlTemplate {
    String header;
    byte[] footer;
    String jsUrl;
    String cssUrl;
    Settings settings;

    @Override
    public byte[] getHeader(ApiRequest request, Object response) {
        try {
            return this.getStringHeader(request, response).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String getStringHeader(ApiRequest request, Object response) {
        Cookie[] cookies;
        String result = this.header;
        URL schemaUrl = ApiContext.getUrlBuilder().resourceCollection(Schema.class);
        result = schemaUrl == null ? result.replace("%SCHEMAS%", "") : result.replace("%SCHEMAS%", schemaUrl.toExternalForm());
        if ("true".equals(SettingsUtil.getSetting(this.settings, "api.dev", "")) && (cookies = request.getServletContext().getRequest().getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if ("js.url".equals(cookie.getName()) && !StringUtils.isEmpty((CharSequence)cookie.getValue())) {
                    result = result.replace("%JS%", cookie.getValue());
                }
                if (!"css.url".equals(cookie.getName()) || StringUtils.isEmpty((CharSequence)cookie.getValue())) continue;
                result = result.replace("%CSS%", cookie.getValue());
            }
        }
        result = result.replace("%JS%", SettingsUtil.getSetting(this.settings, "api.js.url", this.getJsUrl()));
        result = result.replace("%CSS%", SettingsUtil.getSetting(this.settings, "api.css.url", this.getCssUrl()));
        String user = this.getUser(request, response);
        if (user == null) {
            user = "";
        }
        result = result.replace("%USER%", user);
        return result;
    }

    protected String getUser(ApiRequest request, Object response) {
        return null;
    }

    @Override
    public byte[] getFooter(ApiRequest request, Object response) {
        return this.footer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws IOException {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("header.txt");
            if (is == null) {
                is = DefaultHtmlTemplate.class.getResourceAsStream("header.txt");
            }
            this.header = IOUtils.toString((InputStream)is);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        try {
            is = this.getClass().getResourceAsStream("footer.txt");
            if (is == null) {
                is = DefaultHtmlTemplate.class.getResourceAsStream("footer.txt");
            }
            this.footer = IOUtils.toByteArray((InputStream)is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public String getJsUrl() {
        return this.jsUrl;
    }

    public void setJsUrl(String jsUrl) {
        this.jsUrl = jsUrl;
    }

    public String getCssUrl() {
        return this.cssUrl;
    }

    public void setCssUrl(String cssUrl) {
        this.cssUrl = cssUrl;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }
}

