/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.url;

import io.github.ibuildthecloud.gdapi.context.ApiContext;
import io.github.ibuildthecloud.gdapi.factory.SchemaFactory;
import io.github.ibuildthecloud.gdapi.id.IdFormatter;
import io.github.ibuildthecloud.gdapi.model.Resource;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.model.Sort;
import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.url.UrlBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public final class DefaultUrlBuilder
implements UrlBuilder {
    private static final String REMOVE_PARAM_REGEXP = "&?%s=[^&]*";
    ApiRequest apiRequest;
    SchemaFactory schemaFactory;

    public DefaultUrlBuilder(ApiRequest apiRequest, SchemaFactory schemaFactory) {
        this.apiRequest = apiRequest;
        this.schemaFactory = schemaFactory;
    }

    @Override
    public URL resourceReferenceLink(Resource resource) {
        return this.constructBasicUrl(this.getPluralName(resource), resource.getId());
    }

    @Override
    public URL resourceReferenceLink(Class<?> type, String id) {
        IdFormatter formatter = ApiContext.getContext().getIdFormatter();
        Schema schema = this.schemaFactory.getSchema(type);
        return schema == null ? null : this.constructBasicUrl(schema.getPluralName(), formatter.formatId(schema.getId(), id).toString());
    }

    @Override
    public URL resourceReferenceLink(String type, String id) {
        IdFormatter formatter = ApiContext.getContext().getIdFormatter();
        Schema schema = this.schemaFactory.getSchema(type);
        if (schema == null) {
            return this.constructBasicUrl(false, type, formatter.formatId(type, id).toString());
        }
        return this.constructBasicUrl(schema.getPluralName(), formatter.formatId(schema.getId(), id).toString());
    }

    protected String getPluralName(Resource resource) {
        return this.getPluralName(resource.getType());
    }

    protected String getPluralName(String type) {
        return this.schemaFactory.getPluralName(type);
    }

    protected URL constructBasicUrl(boolean lowercase, String ... parts) {
        StringBuilder builder = new StringBuilder().append(this.apiRequest.getResponseUrlBase()).append("/").append(this.apiRequest.getApiVersion());
        for (String part : parts) {
            if (part == null) {
                return null;
            }
            builder.append("/").append(part);
        }
        if (lowercase) {
            return this.toURL(builder.toString().toLowerCase());
        }
        return this.toURL(builder.toString());
    }

    protected URL constructBasicUrl(String ... parts) {
        return this.constructBasicUrl(true, parts);
    }

    @Override
    public URL resourceCollection(Class<?> type) {
        Schema schema = this.schemaFactory.getSchema(type);
        return schema == null ? null : this.constructBasicUrl(schema.getPluralName());
    }

    @Override
    public URL resourceCollection(String type) {
        String plural = this.getPluralName(type);
        return plural == null ? null : this.constructBasicUrl(this.getPluralName(type));
    }

    @Override
    public URL resourceLink(Resource resource, String name) {
        if (name == null) {
            return null;
        }
        return this.constructBasicUrl(this.getPluralName(resource), resource.getId(), name.toLowerCase());
    }

    @Override
    public URL reverseSort(Sort.SortOrder currentOrder) {
        StringBuilder buffer = this.fullUrlToAppendQueryString("order", "marker");
        buffer.append("order").append("=").append(currentOrder.getReverseExternalForm());
        return this.toURL(buffer.toString());
    }

    @Override
    public URL actionLink(Resource resource, String name) {
        return this.constructBasicUrl(this.getPluralName(resource), resource.getId(), "?action=" + name);
    }

    @Override
    public URL sort(String field) {
        StringBuilder buffer = this.fullUrlToAppendQueryString("sort", "order");
        buffer.append("sort").append("=").append(field);
        return this.toURL(buffer.toString());
    }

    @Override
    public URL next(String id) {
        IdFormatter formatter = ApiContext.getContext().getIdFormatter();
        StringBuilder buffer = this.fullUrlToAppendQueryString("marker");
        Object formatted = id;
        if (id != null && id.length() > 0 && id.charAt(0) != 'm') {
            formatted = formatter.formatId("marker", id);
        }
        buffer.append("marker").append("=").append(formatted);
        return this.toURL(buffer.toString());
    }

    protected StringBuilder fullUrlToAppendQueryString(String ... removes) {
        StringBuilder buffer = new StringBuilder(this.apiRequest.getRequestUrl());
        buffer.append("?");
        String queryString = this.removeParameter(this.apiRequest.getQueryString(), removes);
        buffer.append(queryString);
        if (queryString.length() > 0) {
            buffer.append("&");
        }
        return buffer;
    }

    protected URL toURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to create URL for [" + url + "]", e);
        }
    }

    protected String removeParameter(String queryString, String ... names) {
        if (queryString == null) {
            return "";
        }
        for (String name : names) {
            String pattern = String.format(REMOVE_PARAM_REGEXP, Pattern.quote(name));
            queryString = queryString.replaceAll(pattern, "");
        }
        return queryString;
    }

    @Override
    public URL version(String version) {
        StringBuilder builder = new StringBuilder().append(this.apiRequest.getResponseUrlBase()).append("/").append(version);
        return this.toURL(builder.toString());
    }

    @Override
    public URL current() {
        return this.toURL(this.apiRequest.getRequestUrl());
    }

    @Override
    public URL staticResource(String ... parts) {
        StringBuilder builder = new StringBuilder().append(this.apiRequest.getResponseUrlBase()).append("/").append(this.apiRequest.getStaticResourceBase());
        for (String part : parts) {
            if (part == null) {
                return null;
            }
            builder.append("/").append(part);
        }
        return this.toURL(builder.toString().toLowerCase());
    }
}

