/*
 * Decompiled with CFR 0.152.
 */
package io.github.initio;

import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaMQTT {
    private static final Logger logger = LoggerFactory.getLogger(JavaMQTT.class);
    private final MqttAsyncClient client;
    private final MqttConnectOptions options;
    private final ExecutorService executor;
    private final Executor callbackExecutor;
    private int qos = 1;
    private final ConcurrentHashMap<String, MessageListener> topicListeners = new ConcurrentHashMap();
    private volatile MessageListener globalListener;
    private volatile Runnable onReconnectListener;
    private final Object connectLock = new Object();
    private volatile boolean isConnecting = false;

    public JavaMQTT(String serverUri, String clientId, String persistenceDir, final Executor callbackExecutor) throws MqttException {
        this.client = new MqttAsyncClient(serverUri, clientId, (MqttClientPersistence)(persistenceDir != null ? new MqttDefaultFilePersistence(persistenceDir) : new MemoryPersistence()));
        this.options = new MqttConnectOptions();
        this.executor = Executors.newFixedThreadPool(4);
        this.callbackExecutor = callbackExecutor != null ? callbackExecutor : Executors.newCachedThreadPool();
        this.options.setAutomaticReconnect(true);
        this.options.setCleanSession(true);
        this.options.setConnectionTimeout(10);
        this.options.setKeepAliveInterval(20);
        this.options.setMaxInflight(100);
        if (serverUri.startsWith("ssl://")) {
            this.options.setSocketFactory((SocketFactory)this.getTrustAllSSLSocketFactory());
        }
        this.client.setCallback((MqttCallback)new MqttCallbackExtended(){

            public void connectComplete(boolean reconnect, String serverURI) {
                logger.info("Connected to MQTT broker: {}, reconnect: {}", (Object)serverURI, (Object)reconnect);
                if (JavaMQTT.this.onReconnectListener != null) {
                    callbackExecutor.execute(JavaMQTT.this.onReconnectListener);
                }
                if (reconnect) {
                    JavaMQTT.this.resubscribeAll();
                }
            }

            public void connectionLost(Throwable cause) {
                logger.warn("Connection lost", cause);
            }

            public void messageArrived(String topic, MqttMessage message) {
                String payload = new String(message.getPayload());
                logger.debug("Message arrived on topic {}: {}", (Object)topic, (Object)payload);
                callbackExecutor.execute(() -> {
                    try {
                        MessageListener listener = JavaMQTT.this.topicListeners.get(topic);
                        if (listener != null) {
                            listener.onMessage(topic, payload);
                        }
                        if (JavaMQTT.this.globalListener != null) {
                            JavaMQTT.this.globalListener.onMessage(topic, payload);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in message callback", (Throwable)e);
                    }
                });
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
                logger.debug("Delivery complete for message");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String username, String password, final ConnectionListener listener) {
        Object object = this.connectLock;
        synchronized (object) {
            if (this.isConnecting || this.client.isConnected()) {
                return;
            }
            this.isConnecting = true;
        }
        this.executor.execute(() -> {
            block4: {
                try {
                    if (username != null) {
                        this.options.setUserName(username);
                    }
                    if (password != null) {
                        this.options.setPassword(password.toCharArray());
                    }
                    this.client.connect(this.options, null, new IMqttActionListener(){

                        public void onSuccess(IMqttToken asyncActionToken) {
                            logger.info("MQTT connect success");
                            JavaMQTT.this.isConnecting = false;
                            if (listener != null) {
                                JavaMQTT.this.callbackExecutor.execute(listener::onSuccess);
                            }
                        }

                        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                            logger.error("Connect exception", exception);
                            JavaMQTT.this.isConnecting = false;
                            if (listener != null) {
                                JavaMQTT.this.callbackExecutor.execute(() -> listener.onFailure(exception));
                            }
                        }
                    });
                }
                catch (MqttException e) {
                    logger.error("Immediate connect failure", (Throwable)e);
                    this.isConnecting = false;
                    if (listener == null) break block4;
                    this.callbackExecutor.execute(() -> listener.onFailure(e));
                }
            }
        });
    }

    public void put(String topic, String value, boolean retain) {
        this.executor.execute(() -> {
            try {
                if (this.client.isConnected()) {
                    MqttMessage message = new MqttMessage(value.getBytes());
                    message.setQos(this.qos);
                    message.setRetained(retain);
                    this.client.publish(topic, message);
                    logger.debug("Published to {}: {}", (Object)topic, (Object)value);
                } else {
                    logger.warn("Publish failed, client not connected");
                }
            }
            catch (MqttException e) {
                logger.error("Publish exception", (Throwable)e);
            }
        });
    }

    public void put(String topic, String value) {
        this.put(topic, value, false);
    }

    public void putRetain(String topic, String value) {
        this.put(topic, value, true);
    }

    public void subscribe(String topic, MessageListener listener, int qos) {
        this.executor.execute(() -> {
            try {
                if (this.client.isConnected()) {
                    this.client.subscribe(topic, qos);
                    this.topicListeners.put(topic, listener);
                    logger.info("Subscribed to topic: {} with QoS {}", (Object)topic, (Object)qos);
                } else {
                    logger.warn("Subscribe failed, client not connected");
                }
            }
            catch (MqttException e) {
                logger.error("Subscribe exception", (Throwable)e);
            }
        });
    }

    public void subscribe(String topic, MessageListener listener) {
        this.subscribe(topic, listener, this.qos);
    }

    public void unsubscribe(String topic) {
        this.executor.execute(() -> {
            try {
                if (this.client.isConnected()) {
                    this.client.unsubscribe(topic);
                    this.topicListeners.remove(topic);
                    logger.info("Unsubscribed from topic: {}", (Object)topic);
                }
            }
            catch (MqttException e) {
                logger.error("Unsubscribe exception", (Throwable)e);
            }
        });
    }

    public void setGlobalListener(MessageListener listener) {
        this.globalListener = listener;
    }

    public void setOnReconnectListener(Runnable listener) {
        this.onReconnectListener = listener;
    }

    private void resubscribeAll() {
        for (Map.Entry<String, MessageListener> entry : this.topicListeners.entrySet()) {
            try {
                this.client.subscribe(entry.getKey(), this.qos);
                logger.info("Resubscribed to topic: {}", (Object)entry.getKey());
            }
            catch (MqttException e) {
                logger.error("Failed to resubscribe to topic: {}", (Object)entry.getKey(), (Object)e);
            }
        }
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public void disconnect() {
        this.executor.execute(() -> {
            try {
                if (this.client.isConnected()) {
                    this.client.disconnect();
                    logger.info("Disconnected from MQTT broker");
                }
            }
            catch (MqttException e) {
                logger.error("Disconnect exception", (Throwable)e);
            }
        });
    }

    public void setQos(int qos) {
        if (qos >= 0 && qos <= 2) {
            this.qos = qos;
        } else {
            logger.warn("Invalid QoS level: {}", (Object)qos);
        }
    }

    public void close() {
        try {
            this.disconnect();
            this.client.close();
            this.executor.shutdown();
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
            logger.info("JavaMQTT resources cleaned up");
        }
        catch (InterruptedException | MqttException e) {
            logger.error("Error during cleanup", e);
        }
    }

    private SSLSocketFactory getTrustAllSSLSocketFactory() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create SSLSocketFactory", e);
        }
    }

    public static interface ConnectionListener {
        public void onSuccess();

        public void onFailure(Throwable var1);
    }

    public static interface MessageListener {
        public void onMessage(String var1, String var2);
    }
}

