/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.fsm;

import io.github.interacto.fsm.CancelFSMException;
import io.github.interacto.fsm.InputState;
import io.github.interacto.fsm.OutputState;
import java.util.Optional;
import java.util.Set;

public abstract class Transition<E> {
    protected final OutputState<E> src;
    protected final InputState<E> tgt;

    protected Transition(OutputState<E> srcState, InputState<E> tgtState) {
        if (srcState == null || tgtState == null) {
            throw new IllegalArgumentException("States cannot be null");
        }
        this.src = srcState;
        this.tgt = tgtState;
        this.src.addTransition(this);
    }

    public Optional<InputState<E>> execute(E event) throws CancelFSMException {
        if (this.accept(event) && this.isGuardOK(event)) {
            this.src.getFSM().stopCurrentTimeout();
            this.action(event);
            this.src.exit();
            this.tgt.enter();
            return Optional.of(this.tgt);
        }
        return Optional.empty();
    }

    protected void action(E event) {
    }

    protected abstract boolean accept(E var1);

    protected abstract boolean isGuardOK(E var1);

    public abstract Set<Object> getAcceptedEvents();

    public void uninstall() {
    }
}

