/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.command;

import io.github.interacto.command.Command;

public abstract class CommandImpl
implements Command {
    protected Command.CmdStatus status = Command.CmdStatus.CREATED;

    @Override
    public void flush() {
        this.status = Command.CmdStatus.FLUSHED;
    }

    protected void createMemento() {
    }

    @Override
    public boolean doIt() {
        boolean ok;
        if ((this.status == Command.CmdStatus.CREATED || this.status == Command.CmdStatus.EXECUTED) && this.canDo()) {
            if (this.status == Command.CmdStatus.CREATED) {
                this.createMemento();
            }
            ok = true;
            this.doCmdBody();
            this.status = Command.CmdStatus.EXECUTED;
        } else {
            ok = false;
        }
        return ok;
    }

    @Override
    public boolean canDo() {
        return true;
    }

    protected abstract void doCmdBody();

    @Override
    public Command.RegistrationPolicy getRegistrationPolicy() {
        return this.hadEffect() ? Command.RegistrationPolicy.LIMITED : Command.RegistrationPolicy.NONE;
    }

    @Override
    public boolean hadEffect() {
        return this.isDone();
    }

    @Override
    public boolean unregisteredBy(Command cmd) {
        return false;
    }

    @Override
    public void done() {
        if (this.status == Command.CmdStatus.CREATED || this.status == Command.CmdStatus.EXECUTED) {
            this.status = Command.CmdStatus.DONE;
        }
    }

    @Override
    public boolean isDone() {
        return this.status == Command.CmdStatus.DONE;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void cancel() {
        this.status = Command.CmdStatus.CANCELLED;
    }

    @Override
    public Command.CmdStatus getStatus() {
        return this.status;
    }
}

