/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup;

import io.github.isagroup.exceptions.PricingPlanEvaluationException;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.Plan;
import io.github.isagroup.models.PricingManager;
import io.github.isagroup.models.UsageLimit;
import io.github.isagroup.services.yaml.YamlUtils;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.yaml.snakeyaml.error.YAMLException;

@Component
public abstract class PricingContext {
    public abstract String getConfigFilePath();

    public abstract String getJwtSecret();

    public int getJwtExpiration() {
        return 86400000;
    }

    public Boolean userAffectedByPricing() {
        return true;
    }

    public abstract Map<String, Object> getUserContext();

    public abstract String getUserPlan();

    public abstract Object getUserAuthorities();

    public final Map<String, Object> getPlanContext() {
        Plan plan = this.getPricingManager().getPlans().get(this.getUserPlan());
        Map<String, Object> planContext = plan.parseToMap();
        Map<String, Object> planFeaturesContext = plan.getFeatures().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Feature)e.getValue()).getValue() != null ? ((Feature)e.getValue()).getValue() : ((Feature)e.getValue()).getDefaultValue()));
        planContext.put("features", planFeaturesContext);
        Map<String, Object> planUsageLimitMap = plan.getUsageLimits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((UsageLimit)e.getValue()).getValue() != null ? ((UsageLimit)e.getValue()).getValue() : ((UsageLimit)e.getValue()).getDefaultValue()));
        planContext.put("usageLimits", planUsageLimitMap);
        return planContext;
    }

    public final PricingManager getPricingManager() {
        try {
            return YamlUtils.retrieveManagerFromYaml(this.getConfigFilePath());
        }
        catch (YAMLException e) {
            throw new PricingPlanEvaluationException("Error while parsing YAML file");
        }
    }
}

