/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.filters;

import io.github.isagroup.PricingContext;
import io.github.isagroup.PricingEvaluatorUtil;
import io.github.isagroup.services.jwt.JwtUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class RenewTokenFilter
extends OncePerRequestFilter {
    @Autowired
    private JwtUtils jwtUtils;
    @Value(value="${petclinic.app.jwtSecret}")
    private String jwtSecret;
    @Autowired
    private PricingEvaluatorUtil pricingEvaluatorUtil;
    @Autowired
    private PricingContext pricingContext;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String jwtFeatures;
            String newToken;
            String newTokenFeatures;
            String jwt = this.parseJwt(request);
            if (jwt != null && this.jwtUtils.validateJwtToken(jwt) && this.pricingContext.userAffectedByPricing().booleanValue() && !(newTokenFeatures = this.jwtUtils.getFeaturesFromJwtToken(newToken = this.pricingEvaluatorUtil.generateUserToken()).toString()).equals(jwtFeatures = this.jwtUtils.getFeaturesFromJwtToken(jwt).toString())) {
                response.addHeader("New-Token", newToken);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Cannot set user authentication: {}", (Throwable)e);
            this.logger.info((Object)"Anonymous user logged");
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String parseJwt(HttpServletRequest request) {
        String headerAuth = request.getHeader("Authorization");
        if (StringUtils.hasText((String)headerAuth) && headerAuth.startsWith("Bearer ")) {
            return headerAuth.substring(7, headerAuth.length());
        }
        return null;
    }
}

