/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.models;

import io.github.isagroup.models.Feature;
import io.github.isagroup.models.UsageLimit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AddOn {
    private String name;
    private List<String> availableFor;
    private Object price;
    private Object monthlyPrice;
    private Object annualPrice;
    private String unit;
    private Map<String, Feature> features;
    private Map<String, UsageLimit> usageLimits;
    private Map<String, UsageLimit> usageLimitsExtensions;

    public Map<String, Object> serializeAddOn() {
        LinkedHashMap<String, Object> serializedAddOn = new LinkedHashMap<String, Object>();
        if (this.availableFor != null && !this.availableFor.isEmpty()) {
            serializedAddOn.put("availableFor", this.availableFor);
        }
        if (this.price != null) {
            serializedAddOn.put("price", this.price);
        }
        if (this.monthlyPrice != null) {
            serializedAddOn.put("monthlyPrice", this.monthlyPrice);
        }
        if (this.annualPrice != null) {
            serializedAddOn.put("annualPrice", this.annualPrice);
        }
        if (this.unit != null) {
            serializedAddOn.put("unit", this.unit);
        }
        Map features = this.serializeFeatures().orElse(null);
        Map usageLimits = this.serializeUsageLimits().orElse(null);
        Map usageLimitExtensions = this.serializeUsageLimitExtensions().orElse(null);
        serializedAddOn.put("features", features);
        serializedAddOn.put("usageLimits", usageLimits);
        serializedAddOn.put("usageLimitExtensions", usageLimitExtensions);
        return serializedAddOn;
    }

    private <V> Optional<Map<String, V>> serializeValue(V value) {
        if (value == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, V> attributes = new LinkedHashMap<String, V>();
        attributes.put("value", value);
        return Optional.of(attributes);
    }

    private Optional<Map<String, Object>> serializeFeatures() {
        boolean featureMapIsEmpty;
        if (this.features == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, Map<String, Object>> serializedFeatures = new LinkedHashMap<String, Map<String, Object>>();
        for (Feature feature : this.features.values()) {
            Optional<Map<String, Object>> serializedFeature = this.serializeValue(feature.getValue());
            if (!serializedFeature.isPresent()) continue;
            serializedFeatures.put(feature.getName(), serializedFeature.get());
        }
        boolean bl = featureMapIsEmpty = serializedFeatures.size() == 0;
        if (featureMapIsEmpty) {
            return Optional.empty();
        }
        return Optional.of(serializedFeatures);
    }

    private Optional<Map<String, Object>> serializeUsageLimits() {
        boolean usageLimitMapIsEmpty;
        if (this.usageLimits == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, Map<String, Object>> serializedUsageLimits = new LinkedHashMap<String, Map<String, Object>>();
        for (UsageLimit usageLimit : this.usageLimits.values()) {
            Optional<Map<String, Object>> serializedUsageLimit = this.serializeValue(usageLimit.getValue());
            if (!serializedUsageLimit.isPresent()) continue;
            serializedUsageLimits.put(usageLimit.getName(), serializedUsageLimit.get());
        }
        boolean bl = usageLimitMapIsEmpty = serializedUsageLimits.size() == 0;
        if (usageLimitMapIsEmpty) {
            return Optional.empty();
        }
        return Optional.of(serializedUsageLimits);
    }

    private Optional<Map<String, Object>> serializeUsageLimitExtensions() {
        boolean usageLimitMapIsEmpty;
        if (this.usageLimits == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, Map<String, Object>> serializedUsageLimitExtensions = new LinkedHashMap<String, Map<String, Object>>();
        for (UsageLimit usageLimitExtension : this.usageLimits.values()) {
            Optional<Map<String, Object>> serializedUsageLimit = this.serializeValue(usageLimitExtension.getValue());
            if (!serializedUsageLimit.isPresent()) continue;
            serializedUsageLimitExtensions.put(usageLimitExtension.getName(), serializedUsageLimit.get());
        }
        boolean bl = usageLimitMapIsEmpty = serializedUsageLimitExtensions.size() == 0;
        if (usageLimitMapIsEmpty) {
            return Optional.empty();
        }
        return Optional.of(serializedUsageLimitExtensions);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAvailableFor() {
        return this.availableFor;
    }

    public Object getPrice() {
        return this.price;
    }

    public Object getMonthlyPrice() {
        return this.monthlyPrice;
    }

    public Object getAnnualPrice() {
        return this.annualPrice;
    }

    public String getUnit() {
        return this.unit;
    }

    public Map<String, Feature> getFeatures() {
        return this.features;
    }

    public Map<String, UsageLimit> getUsageLimits() {
        return this.usageLimits;
    }

    public Map<String, UsageLimit> getUsageLimitsExtensions() {
        return this.usageLimitsExtensions;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAvailableFor(List<String> availableFor) {
        this.availableFor = availableFor;
    }

    public void setPrice(Object price) {
        this.price = price;
    }

    public void setMonthlyPrice(Object monthlyPrice) {
        this.monthlyPrice = monthlyPrice;
    }

    public void setAnnualPrice(Object annualPrice) {
        this.annualPrice = annualPrice;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setFeatures(Map<String, Feature> features) {
        this.features = features;
    }

    public void setUsageLimits(Map<String, UsageLimit> usageLimits) {
        this.usageLimits = usageLimits;
    }

    public void setUsageLimitsExtensions(Map<String, UsageLimit> usageLimitsExtensions) {
        this.usageLimitsExtensions = usageLimitsExtensions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddOn)) {
            return false;
        }
        AddOn other = (AddOn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$availableFor = this.getAvailableFor();
        List<String> other$availableFor = other.getAvailableFor();
        if (this$availableFor == null ? other$availableFor != null : !((Object)this$availableFor).equals(other$availableFor)) {
            return false;
        }
        Object this$price = this.getPrice();
        Object other$price = other.getPrice();
        if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
            return false;
        }
        Object this$monthlyPrice = this.getMonthlyPrice();
        Object other$monthlyPrice = other.getMonthlyPrice();
        if (this$monthlyPrice == null ? other$monthlyPrice != null : !this$monthlyPrice.equals(other$monthlyPrice)) {
            return false;
        }
        Object this$annualPrice = this.getAnnualPrice();
        Object other$annualPrice = other.getAnnualPrice();
        if (this$annualPrice == null ? other$annualPrice != null : !this$annualPrice.equals(other$annualPrice)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        Map<String, Feature> this$features = this.getFeatures();
        Map<String, Feature> other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !((Object)this$features).equals(other$features)) {
            return false;
        }
        Map<String, UsageLimit> this$usageLimits = this.getUsageLimits();
        Map<String, UsageLimit> other$usageLimits = other.getUsageLimits();
        if (this$usageLimits == null ? other$usageLimits != null : !((Object)this$usageLimits).equals(other$usageLimits)) {
            return false;
        }
        Map<String, UsageLimit> this$usageLimitsExtensions = this.getUsageLimitsExtensions();
        Map<String, UsageLimit> other$usageLimitsExtensions = other.getUsageLimitsExtensions();
        return !(this$usageLimitsExtensions == null ? other$usageLimitsExtensions != null : !((Object)this$usageLimitsExtensions).equals(other$usageLimitsExtensions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddOn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $availableFor = this.getAvailableFor();
        result = result * 59 + ($availableFor == null ? 43 : ((Object)$availableFor).hashCode());
        Object $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        Object $monthlyPrice = this.getMonthlyPrice();
        result = result * 59 + ($monthlyPrice == null ? 43 : $monthlyPrice.hashCode());
        Object $annualPrice = this.getAnnualPrice();
        result = result * 59 + ($annualPrice == null ? 43 : $annualPrice.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        Map<String, Feature> $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        Map<String, UsageLimit> $usageLimits = this.getUsageLimits();
        result = result * 59 + ($usageLimits == null ? 43 : ((Object)$usageLimits).hashCode());
        Map<String, UsageLimit> $usageLimitsExtensions = this.getUsageLimitsExtensions();
        result = result * 59 + ($usageLimitsExtensions == null ? 43 : ((Object)$usageLimitsExtensions).hashCode());
        return result;
    }
}

