/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.models;

import io.github.isagroup.models.AddOn;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.Plan;
import io.github.isagroup.models.UsageLimit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PricingManager {
    private String saasName;
    private int day;
    private int month;
    private int year;
    private String currency;
    private Boolean hasAnnualPayment;
    private Map<String, Feature> features;
    private Map<String, UsageLimit> usageLimits;
    private Map<String, Plan> plans;
    private Map<String, AddOn> addOns;

    public List<String> getPlanNames() {
        return List.copyOf(this.plans.keySet());
    }

    public Map<String, Object> getPlanUsageLimits(String planName) {
        LinkedHashMap<String, Object> usageLimitsContext = new LinkedHashMap<String, Object>();
        Map<String, UsageLimit> planUsageLimits = this.plans.get(planName).getUsageLimits();
        Map<String, UsageLimit> defaultUsageLimits = this.usageLimits;
        for (String usageLimitName : defaultUsageLimits.keySet()) {
            UsageLimit defaultUsageLimitValue = this.usageLimits.get(usageLimitName);
            UsageLimit planUsageLimitValue = planUsageLimits.get(usageLimitName);
            boolean planUsageLimitOverwritesDefaultUsageLimit = planUsageLimitValue != null;
            UsageLimit currentValue = defaultUsageLimitValue;
            if (planUsageLimitOverwritesDefaultUsageLimit) {
                currentValue = planUsageLimitValue;
            }
            usageLimitsContext.put(usageLimitName, currentValue);
        }
        return usageLimitsContext;
    }

    public String getSaasName() {
        return this.saasName;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Boolean getHasAnnualPayment() {
        return this.hasAnnualPayment;
    }

    public Map<String, Feature> getFeatures() {
        return this.features;
    }

    public Map<String, UsageLimit> getUsageLimits() {
        return this.usageLimits;
    }

    public Map<String, Plan> getPlans() {
        return this.plans;
    }

    public Map<String, AddOn> getAddOns() {
        return this.addOns;
    }

    public void setSaasName(String saasName) {
        this.saasName = saasName;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setHasAnnualPayment(Boolean hasAnnualPayment) {
        this.hasAnnualPayment = hasAnnualPayment;
    }

    public void setFeatures(Map<String, Feature> features) {
        this.features = features;
    }

    public void setUsageLimits(Map<String, UsageLimit> usageLimits) {
        this.usageLimits = usageLimits;
    }

    public void setPlans(Map<String, Plan> plans) {
        this.plans = plans;
    }

    public void setAddOns(Map<String, AddOn> addOns) {
        this.addOns = addOns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PricingManager)) {
            return false;
        }
        PricingManager other = (PricingManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDay() != other.getDay()) {
            return false;
        }
        if (this.getMonth() != other.getMonth()) {
            return false;
        }
        if (this.getYear() != other.getYear()) {
            return false;
        }
        Boolean this$hasAnnualPayment = this.getHasAnnualPayment();
        Boolean other$hasAnnualPayment = other.getHasAnnualPayment();
        if (this$hasAnnualPayment == null ? other$hasAnnualPayment != null : !((Object)this$hasAnnualPayment).equals(other$hasAnnualPayment)) {
            return false;
        }
        String this$saasName = this.getSaasName();
        String other$saasName = other.getSaasName();
        if (this$saasName == null ? other$saasName != null : !this$saasName.equals(other$saasName)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Map<String, Feature> this$features = this.getFeatures();
        Map<String, Feature> other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !((Object)this$features).equals(other$features)) {
            return false;
        }
        Map<String, UsageLimit> this$usageLimits = this.getUsageLimits();
        Map<String, UsageLimit> other$usageLimits = other.getUsageLimits();
        if (this$usageLimits == null ? other$usageLimits != null : !((Object)this$usageLimits).equals(other$usageLimits)) {
            return false;
        }
        Map<String, Plan> this$plans = this.getPlans();
        Map<String, Plan> other$plans = other.getPlans();
        if (this$plans == null ? other$plans != null : !((Object)this$plans).equals(other$plans)) {
            return false;
        }
        Map<String, AddOn> this$addOns = this.getAddOns();
        Map<String, AddOn> other$addOns = other.getAddOns();
        return !(this$addOns == null ? other$addOns != null : !((Object)this$addOns).equals(other$addOns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PricingManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDay();
        result = result * 59 + this.getMonth();
        result = result * 59 + this.getYear();
        Boolean $hasAnnualPayment = this.getHasAnnualPayment();
        result = result * 59 + ($hasAnnualPayment == null ? 43 : ((Object)$hasAnnualPayment).hashCode());
        String $saasName = this.getSaasName();
        result = result * 59 + ($saasName == null ? 43 : $saasName.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Map<String, Feature> $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        Map<String, UsageLimit> $usageLimits = this.getUsageLimits();
        result = result * 59 + ($usageLimits == null ? 43 : ((Object)$usageLimits).hashCode());
        Map<String, Plan> $plans = this.getPlans();
        result = result * 59 + ($plans == null ? 43 : ((Object)$plans).hashCode());
        Map<String, AddOn> $addOns = this.getAddOns();
        result = result * 59 + ($addOns == null ? 43 : ((Object)$addOns).hashCode());
        return result;
    }
}

