/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.models;

import io.github.isagroup.exceptions.CloneUsageLimitException;
import io.github.isagroup.models.UsageLimitType;
import io.github.isagroup.models.ValueType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class UsageLimit
implements Serializable {
    private String name;
    private String description;
    private ValueType valueType;
    private Object defaultValue;
    protected UsageLimitType type;
    private String unit;
    private transient Object value;
    private List<String> linkedFeatures = new ArrayList<String>();
    private String expression;
    private String serverExpression;

    public boolean isLinkedToFeature(String featureName) {
        return this.linkedFeatures.contains(featureName);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        if (this.description != null) {
            attributes.put("description", this.description);
        }
        if (this.valueType != null) {
            attributes.put("valueType", this.valueType.toString());
        }
        if (this.defaultValue != null) {
            attributes.put("defaultValue", this.defaultValue);
        }
        if (this.unit != null) {
            attributes.put("unit", this.unit);
        }
        attributes.put("type", this.type.toString());
        if (this.linkedFeatures != null && !this.linkedFeatures.isEmpty()) {
            attributes.put("linkedFeatures", this.linkedFeatures);
        }
        if (this.expression != null) {
            attributes.put("expression", this.expression);
        }
        if (this.serverExpression != null) {
            attributes.put("serverExpression", this.serverExpression);
        }
        return attributes;
    }

    public static UsageLimit cloneUsageLimit(UsageLimit original) throws CloneUsageLimitException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(original);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return (UsageLimit)objectInputStream.readObject();
        }
        catch (Exception e) {
            throw new CloneUsageLimitException("Error cloning usageLimit");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public UsageLimitType getType() {
        return this.type;
    }

    public String getUnit() {
        return this.unit;
    }

    public Object getValue() {
        return this.value;
    }

    public List<String> getLinkedFeatures() {
        return this.linkedFeatures;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getServerExpression() {
        return this.serverExpression;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setType(UsageLimitType type) {
        this.type = type;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setLinkedFeatures(List<String> linkedFeatures) {
        this.linkedFeatures = linkedFeatures;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setServerExpression(String serverExpression) {
        this.serverExpression = serverExpression;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsageLimit)) {
            return false;
        }
        UsageLimit other = (UsageLimit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ValueType this$valueType = this.getValueType();
        ValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !((Object)((Object)this$valueType)).equals((Object)other$valueType)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        UsageLimitType this$type = this.getType();
        UsageLimitType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        List<String> this$linkedFeatures = this.getLinkedFeatures();
        List<String> other$linkedFeatures = other.getLinkedFeatures();
        if (this$linkedFeatures == null ? other$linkedFeatures != null : !((Object)this$linkedFeatures).equals(other$linkedFeatures)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        String this$serverExpression = this.getServerExpression();
        String other$serverExpression = other.getServerExpression();
        return !(this$serverExpression == null ? other$serverExpression != null : !this$serverExpression.equals(other$serverExpression));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UsageLimit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : ((Object)((Object)$valueType)).hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        UsageLimitType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        List<String> $linkedFeatures = this.getLinkedFeatures();
        result = result * 59 + ($linkedFeatures == null ? 43 : ((Object)$linkedFeatures).hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        String $serverExpression = this.getServerExpression();
        result = result * 59 + ($serverExpression == null ? 43 : $serverExpression.hashCode());
        return result;
    }
}

