/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.services.serializer;

import io.github.isagroup.exceptions.SerializerException;
import io.github.isagroup.models.AddOn;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.Plan;
import io.github.isagroup.models.PricingManager;
import io.github.isagroup.models.UsageLimit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class PricingManagerSerializer {
    private PricingManager pricingManager;
    private Map<String, Object> serializedPricingManager;

    public PricingManagerSerializer(PricingManager pricingManager) {
        this.pricingManager = pricingManager;
        this.serializedPricingManager = new LinkedHashMap<String, Object>();
    }

    private void initPricingManagerMetadata() {
        this.serializedPricingManager.put("saasName", this.pricingManager.getSaasName());
        this.serializedPricingManager.put("day", this.pricingManager.getDay());
        this.serializedPricingManager.put("month", this.pricingManager.getMonth());
        this.serializedPricingManager.put("year", this.pricingManager.getYear());
        this.serializedPricingManager.put("currency", this.pricingManager.getCurrency());
        this.serializedPricingManager.put("hasAnnualPayment", this.pricingManager.getHasAnnualPayment());
    }

    public Map<String, Object> serialize() throws SerializerException {
        this.initPricingManagerMetadata();
        if (this.pricingManager.getFeatures() == null) {
            throw new SerializerException("Features are null. Filling the pricing with features is mandatory.");
        }
        if (this.pricingManager.getPlans() == null && this.pricingManager.getAddOns() == null) {
            throw new SerializerException("Plans and AddOns are null. You have to set at least one of them.");
        }
        this.serializedPricingManager.put("features", this.serializeFeatures());
        this.serializedPricingManager.put("usageLimits", this.serializeUsageLimits());
        this.serializedPricingManager.put("plans", this.serializePlans());
        this.serializedPricingManager.put("addOns", this.serializeAddOns().orElse(null));
        return this.serializedPricingManager;
    }

    private Map<String, Object> serializeFeatures() {
        LinkedHashMap<String, Object> serializedFeatures = new LinkedHashMap<String, Object>();
        for (Feature feature : this.pricingManager.getFeatures().values()) {
            serializedFeatures.put(feature.getName(), feature.serializeFeature());
        }
        return serializedFeatures;
    }

    private Map<String, Object> serializeUsageLimits() {
        LinkedHashMap<String, Object> serializedUsageLimits = new LinkedHashMap<String, Object>();
        if (this.pricingManager.getUsageLimits() == null) {
            return null;
        }
        for (UsageLimit usageLimit : this.pricingManager.getUsageLimits().values()) {
            serializedUsageLimits.put(usageLimit.getName(), usageLimit.serialize());
        }
        return serializedUsageLimits;
    }

    private Map<String, Object> serializePlans() {
        LinkedHashMap<String, Object> serializedPlans = new LinkedHashMap<String, Object>();
        for (Plan plan : this.pricingManager.getPlans().values()) {
            serializedPlans.put(plan.getName(), plan.serializePlan());
        }
        return serializedPlans;
    }

    public Optional<Map<String, Object>> serializeAddOns() {
        if (this.pricingManager.getAddOns() == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, Map<String, Object>> serializedAddOns = new LinkedHashMap<String, Map<String, Object>>();
        for (AddOn addOn : this.pricingManager.getAddOns().values()) {
            serializedAddOns.put(addOn.getName(), addOn.serializeAddOn());
        }
        return Optional.of(serializedAddOns);
    }
}

