/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.models;

import io.github.isagroup.models.Feature;
import io.github.isagroup.models.UsageLimit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class Plan {
    private String name;
    private String description;
    private Object monthlyPrice;
    private Object annualPrice;
    private String unit;
    private Map<String, Feature> features;
    private Map<String, UsageLimit> usageLimits;

    public Map<String, Object> parseToMap() {
        LinkedHashMap<String, Object> planMap = new LinkedHashMap<String, Object>();
        planMap.put("name", this.name);
        planMap.put("description", this.description);
        planMap.put("monthlyPrice", this.monthlyPrice);
        planMap.put("annualPrice", this.annualPrice);
        planMap.put("unit", this.unit);
        planMap.put("features", this.features);
        planMap.put("usageLimits", this.usageLimits);
        return planMap;
    }

    public Map<String, Object> serializePlan() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put("description", this.description);
        attributes.put("monthlyPrice", this.monthlyPrice);
        attributes.put("annualPrice", this.annualPrice);
        attributes.put("unit", this.unit);
        Map features = this.serializeFeatures().orElse(null);
        Map usageLimits = this.serializeUsageLimits().orElse(null);
        attributes.put("features", features);
        attributes.put("usageLimits", usageLimits);
        return attributes;
    }

    private <V> Optional<Map<String, V>> serializeValue(V value) {
        if (value == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, V> attributes = new LinkedHashMap<String, V>();
        attributes.put("value", value);
        return Optional.of(attributes);
    }

    private Optional<Map<String, Object>> serializeFeatures() {
        boolean featureMapIsEmpty;
        if (this.features == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, Map<String, Object>> serializedFeatures = new LinkedHashMap<String, Map<String, Object>>();
        for (Feature feature : this.features.values()) {
            Optional<Map<String, Object>> serializedFeature = this.serializeValue(feature.getValue());
            if (!serializedFeature.isPresent()) continue;
            serializedFeatures.put(feature.getName(), serializedFeature.get());
        }
        boolean bl = featureMapIsEmpty = serializedFeatures.size() == 0;
        if (featureMapIsEmpty) {
            return Optional.empty();
        }
        return Optional.of(serializedFeatures);
    }

    private Optional<Map<String, Object>> serializeUsageLimits() {
        boolean usageLimitMapIsEmpty;
        if (this.usageLimits == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, Map<String, Object>> serializedUsageLimits = new LinkedHashMap<String, Map<String, Object>>();
        for (UsageLimit usageLimit : this.usageLimits.values()) {
            Optional<Map<String, Object>> serializedUsageLimit = this.serializeValue(usageLimit.getValue());
            if (!serializedUsageLimit.isPresent()) continue;
            serializedUsageLimits.put(usageLimit.getName(), serializedUsageLimit.get());
        }
        boolean bl = usageLimitMapIsEmpty = serializedUsageLimits.size() == 0;
        if (usageLimitMapIsEmpty) {
            return Optional.empty();
        }
        return Optional.of(serializedUsageLimits);
    }

    public String toString() {
        return "Plan[name=" + this.name + ", monthlyPrice=" + this.monthlyPrice + ", annualPrice=" + this.annualPrice + ", unit=" + this.unit + ", features: " + this.features.get("superAdminRole") + "]";
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getMonthlyPrice() {
        return this.monthlyPrice;
    }

    public Object getAnnualPrice() {
        return this.annualPrice;
    }

    public String getUnit() {
        return this.unit;
    }

    public Map<String, Feature> getFeatures() {
        return this.features;
    }

    public Map<String, UsageLimit> getUsageLimits() {
        return this.usageLimits;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMonthlyPrice(Object monthlyPrice) {
        this.monthlyPrice = monthlyPrice;
    }

    public void setAnnualPrice(Object annualPrice) {
        this.annualPrice = annualPrice;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setFeatures(Map<String, Feature> features) {
        this.features = features;
    }

    public void setUsageLimits(Map<String, UsageLimit> usageLimits) {
        this.usageLimits = usageLimits;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plan)) {
            return false;
        }
        Plan other = (Plan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Object this$monthlyPrice = this.getMonthlyPrice();
        Object other$monthlyPrice = other.getMonthlyPrice();
        if (this$monthlyPrice == null ? other$monthlyPrice != null : !this$monthlyPrice.equals(other$monthlyPrice)) {
            return false;
        }
        Object this$annualPrice = this.getAnnualPrice();
        Object other$annualPrice = other.getAnnualPrice();
        if (this$annualPrice == null ? other$annualPrice != null : !this$annualPrice.equals(other$annualPrice)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        Map<String, Feature> this$features = this.getFeatures();
        Map<String, Feature> other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !((Object)this$features).equals(other$features)) {
            return false;
        }
        Map<String, UsageLimit> this$usageLimits = this.getUsageLimits();
        Map<String, UsageLimit> other$usageLimits = other.getUsageLimits();
        return !(this$usageLimits == null ? other$usageLimits != null : !((Object)this$usageLimits).equals(other$usageLimits));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Plan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Object $monthlyPrice = this.getMonthlyPrice();
        result = result * 59 + ($monthlyPrice == null ? 43 : $monthlyPrice.hashCode());
        Object $annualPrice = this.getAnnualPrice();
        result = result * 59 + ($annualPrice == null ? 43 : $annualPrice.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        Map<String, Feature> $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        Map<String, UsageLimit> $usageLimits = this.getUsageLimits();
        result = result * 59 + ($usageLimits == null ? 43 : ((Object)$usageLimits).hashCode());
        return result;
    }
}

