/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.filters;

import io.github.isagroup.PricingContext;
import io.github.isagroup.PricingEvaluatorUtil;
import io.github.isagroup.services.jwt.PricingJwtUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class RenewTokenFilter
extends OncePerRequestFilter {
    @Autowired
    private PricingJwtUtils jwtUtils;
    @Value(value="${petclinic.app.jwtSecret}")
    private String jwtSecret;
    @Autowired
    private PricingEvaluatorUtil pricingEvaluatorUtil;
    @Autowired
    private PricingContext pricingContext;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String pricingJwt = this.parsePricingJwt(request);
        String authJwt = this.parseAuthJwt(request);
        if (authJwt != null && this.jwtUtils.validateJwtToken(authJwt) && this.pricingContext.userAffectedByPricing().booleanValue()) {
            String newToken = this.pricingEvaluatorUtil.generateUserToken();
            String newTokenFeatures = this.jwtUtils.getFeaturesFromJwtToken(newToken).toString();
            String jwtFeatures = "";
            if (pricingJwt != null && !pricingJwt.equals("null")) {
                jwtFeatures = this.jwtUtils.getFeaturesFromJwtToken(pricingJwt).toString();
            }
            if (!newTokenFeatures.equals(jwtFeatures)) {
                response.addHeader("Pricing-Token", newToken);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String parsePricingJwt(HttpServletRequest request) {
        String headerPricing = request.getHeader("Pricing-Token");
        if (StringUtils.hasText((String)headerPricing)) {
            return headerPricing;
        }
        return null;
    }

    private String parseAuthJwt(HttpServletRequest request) {
        String headerAuth = request.getHeader("Authorization");
        if (StringUtils.hasText((String)headerAuth) && headerAuth.startsWith("Bearer ")) {
            return headerAuth.substring(7, headerAuth.length());
        }
        return null;
    }
}

